package com.ebmwebsourcing.easiergov.cli.impl.command;

import java.util.ArrayList;
import java.util.List;

import org.jdom.Element;

import com.ebmwebsourcing.easiergov.client.impl.soap.ConnexionManagerClientImplSOAP;
import com.ebmwebsourcing.easyesb.cli.api.Command;
import com.ebmwebsourcing.easyesb.cli.impl.AbstractCommandManager;
import com.ebmwebsourcing.easyesb.cli.impl.command.AbstractScriptCommand;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;

public class GOVScriptCommand extends AbstractScriptCommand<ConnexionManagerClientImplSOAP> {


	public GOVScriptCommand(ConnexionManagerClientImplSOAP client, AbstractCommandManager cm) throws ESBException {
		super(client, cm);
	}

	public String executeAction(Element command) {
		String res = null;
		if("ConnectToEnvironment".equals(command.getName())){
			String url = command.getChild("Url", Command.NAMESPACE_JDOM).getTextTrim();
			List<String> args = new ArrayList<String>();
			args.add(url);

			ConnectToEnvironmentCommand impl = (ConnectToEnvironmentCommand) cm.findCommand("co");
			impl.process(args);

			res = "Connect To Environment: " + impl.getResult();
		}
		return res;
	}

}
