package com.ebmwebsourcing.easiergov.cli.impl.command;

import java.io.File;
import java.util.List;

import com.ebmwebsourcing.easyesb.cli.impl.AbstractCommand;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyevent.impl.client.soap.EventManagerClientImplSOAP;
import com.petalslink.events_api._1.PublishTopicNamespaceFromURL;
import com.petalslink.events_api._1.PublishTopicNamespaceFromURLResponse;


public class PublishTopicNamespaceFromUrlCommand extends AbstractCommand<EventManagerClientImplSOAP> {

	private String url;
	
	
	public PublishTopicNamespaceFromUrlCommand(EventManagerClientImplSOAP client) throws ESBException {
		super(client);
		this.setName("PublishNamespaceFromUrl");
		this.setDescription("Publish Namespace From Url");
		this.setShortcut("pt");
	}
	
	@Override
	public void execute() {
		try {
			PublishTopicNamespaceFromURL request = new PublishTopicNamespaceFromURL();
			if(this.url.startsWith(".")) {
				this.url = "file:///" + new File(this.url).getAbsolutePath();
			}
			request.setTopicNamespaceUrl(this.url);
			PublishTopicNamespaceFromURLResponse res = this.getClient().publishTopicNamespaceFromURL(request);
			setResult("TopicNamespace is loaded: " + this.url);
			this.resultCode = AbstractCommand.OK_CODE;
			
		} catch (Throwable e) {
			e.printStackTrace();
			setResult(e.getLocalizedMessage());
			this.resultCode = AbstractCommand.ERROR_CODE;
			
		}
		
	}

	@Override
	protected int doProcess(List<String> args) {
		this.url = args.get(0);
		execute();
		return this.resultCode;
		
	}

	@Override
	protected boolean validateArgs(List<String> args) {
		if(args.size() == 1){
			return true;
		}
		return false;
	}

	@Override
	public String toString() {
		return "pt <url> \t\t\t\t\t\t{Publish Namespace From Url}";
	}
	
}
