package com.ebmwebsourcing.easiergov.cli.impl.command;

import java.io.File;
import java.util.List;

import com.ebmwebsourcing.easiergov.client.impl.soap.DataManagerClientImplSOAP;
import com.ebmwebsourcing.easyesb.cli.impl.AbstractCommand;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.petalslink.data_api._1.PublishSchemaFromURL;
import com.petalslink.data_api._1.PublishSchemaFromURLResponse;


public class PublishSchemaFromUrlCommand extends AbstractCommand<DataManagerClientImplSOAP> {

	private String url;
	
	
	public PublishSchemaFromUrlCommand(DataManagerClientImplSOAP client) throws ESBException {
		super(client);
		this.setName("PublishSchema");
		this.setDescription("Publish Schema From Url");
		this.setShortcut("psc");
	}
	
	@Override
	public void execute() {
		try {
			PublishSchemaFromURL request = new PublishSchemaFromURL();
			if(this.url.startsWith(".")) {
				this.url = "file:///" + new File(this.url).getAbsolutePath();
			}
			request.setXsdUrl(this.url);
			PublishSchemaFromURLResponse res = this.getClient().publishSchemaFromURL(request);
			setResult("Schema is loaded: " + this.url);
			this.resultCode = AbstractCommand.OK_CODE;
			
		} catch (Throwable e) {
			e.printStackTrace();
			setResult(e.getLocalizedMessage());
			this.resultCode = AbstractCommand.ERROR_CODE;
			
		}
		
	}

	@Override
	protected int doProcess(List<String> args) {
		this.url = args.get(0);
		execute();
		return this.resultCode;
		
	}

	@Override
	protected boolean validateArgs(List<String> args) {
		if(args.size() == 1){
			return true;
		}
		return false;
	}

	@Override
	public String toString() {
		return "psc <url> \t\t\t\t\t\t{Publish Schema From Url}";
	}
	
}
