/**
 * EasierSBS project - Java file
 * Copyright (C) 2011 EBM WebSourcing - Petals Link
 * 
 * EasySWS is free project: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * EasySWS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this program.
 * If not, see <http://www.gnu.org/licenses/lgpl-3.0.txt>.	
 * 
 */ 
package com.petalslink.easiersbs.reasoner.api.ontology;

import java.io.File;
import java.net.URI;
import java.util.Map;
import java.util.Set;

import com.petalslink.easiersbs.reasoner.api.ReasonerException;

/**
 * @author Nicolas Boissel-Dallier - Petals Link
 */
public interface OntologyManager {
	
	void clearOntology();
	
	void importOntology(URI uri) throws ReasonerException;
	
	void importOntology(File file) throws ReasonerException;
	
	void importOntology(URI uri, boolean technical) throws ReasonerException;
	
	void importOntology(File file, boolean technical) throws ReasonerException;
	
	void exportOntology(URI target) throws ReasonerException;
	
	Map<URI, Integer> getOntologiesInfo();
	
	Set<URI> getNamespaceUris();
	
	boolean isTechnicalOntology(URI namespace);
	
}
