/**
 * EasierSBS project - Java file
 * Copyright (C) 2011 EBM WebSourcing - Petals Link
 * 
 * EasySWS is free project: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * EasySWS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this program.
 * If not, see <http://www.gnu.org/licenses/lgpl-3.0.txt>.	
 * 
 */ 
package com.petalslink.easiersbs.registry.service.api.model;

import com.ebmwebsourcing.easyschema10.api.element.Element;


/**
 * @author Nicolas Boissel-Dallier - Petals Link
 */
public interface SemanticElement extends SemanticPart {

	/**
	 * Is this semantic element required or optional ?
	 * 
	 * @return boolean	 
	 */
	public boolean isRequired();

	/**
	 * Set the semantic element required or not.
	 * 
	 * @param required	Is this semantic element required or optional ?	 
	 */
	public void setRequired(boolean required);
	
	/**
	 * Get the syntactic element description
	 * 
	 * @return related element (EasySchema element)
	 */
	public Element getElement();
	
	/**
	 * Get the syntactic element description
	 * 
	 * @return related element (EasySchema element)
	 */
	public void setElement(Element element);
	
}
