/**
 * EasierSBS project - Java file
 * Copyright (C) 2011 EBM WebSourcing - Petals Link
 * 
 * EasySWS is free project: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * EasySWS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this program.
 * If not, see <http://www.gnu.org/licenses/lgpl-3.0.txt>.	
 * 
 */ 
package com.petalslink.easiersbs.registry.service.impl.model;

import java.util.HashSet;
import java.util.Set;

import javax.xml.namespace.QName;

import com.petalslink.easiersbs.registry.service.api.model.Partner;
import com.petalslink.easiersbs.registry.service.api.model.SemanticElement;
import com.petalslink.easiersbs.registry.service.api.model.SemanticPart;
import com.petalslink.easiersbs.registry.service.api.model.SemanticProfile;


/**
 * @author Nicolas Boissel-Dallier - Petals Link
 */
/**
 * @author Nicolas Boissel-Dallier - Petals Link
 */
public class SemanticProfileImpl implements SemanticProfile {

	private Set<SemanticElement> semanticInputs = new HashSet<SemanticElement>();
	private Set<SemanticElement> semanticOutputs = new HashSet<SemanticElement>();
	private SemanticPart semanticOperation = null;
	private SemanticPart semanticInterface = null;
	
	private QName operationQName = null;
	private Set<QName> serviceQNames = new HashSet<QName>();
	
	private Partner partner = null;
	
	public SemanticProfileImpl(){
		
	}

	public void addInputSemanticElement(SemanticElement semanticInput) {
		semanticInputs.add(semanticInput);
	}

	public void addOutputSemanticElement(SemanticElement semanticOutput) {
		semanticOutputs.add(semanticOutput);
	}

	public Set<SemanticElement> getInputSemanticElements() {
		return semanticInputs;
	}

	public Set<SemanticElement> getOutputSemanticElements() {
		return semanticOutputs;
	}

	public SemanticPart getSemanticInterface() {
		return semanticInterface;
	}

	public SemanticPart getSemanticOperation() {
		return semanticOperation;
	}

	public void removeInputSemanticElement(SemanticElement semanticInput) {
		semanticInputs.remove(semanticInput);
	}

	public void removeOutputSemanticElement(SemanticElement semanticOutput) {
		semanticOutputs.remove(semanticOutput);
	}

	public void setSemanticInterface(SemanticPart semanticInterface) {
		this.semanticInterface = semanticInterface;		
	}

	public void setSemanticOperation(SemanticPart semanticOperation) {
		this.semanticOperation = semanticOperation;
	}

	public QName getOperationQName() {
		return operationQName;
	}

	public void setOperationQName(QName operationQName) {
		this.operationQName = operationQName;
	}

	public Set<QName> getServiceQNames() {
		return serviceQNames;
	}

	public void addServiceQName(QName serviceQName) {
		this.serviceQNames.add(serviceQName);
	}
	
	public void removeServiceQName(QName serviceQName) {
		this.serviceQNames.remove(serviceQName);
	}
	
	public void setInputSemanticElements(Set<SemanticElement> semanticInputs) {
		this.semanticInputs = semanticInputs;
	}


	public void setOutputSemanticElements(Set<SemanticElement> semanticOutputs) {
		this.semanticOutputs = semanticOutputs;
	}

	/**
	 * @return the partner
	 */
	public Partner getPartner() {
		return partner;
	}
	
	public boolean hasPartner() {
		return partner != null;
	}

	/**
	 * @param partner the partner to set
	 */
	public void setPartner(Partner partner) {
		this.partner = partner;
	}

	@Override
	public boolean equals(Object other) {
		if(other instanceof SemanticProfile){
			return this.operationQName.equals(((SemanticProfile)other).getOperationQName());
		}else{
			return false;
		}
	}
	
	@Override
	public int hashCode() {
		return this.operationQName.hashCode();
	}
	
	@Override
	public String toString(){
		StringBuilder str = new StringBuilder();
		str.append("++++++++++++++++++++++");
		str.append("\nSemantic profile of operation " + operationQName.toString());
		str.append("\n----------------------");
		str.append("\nThis operation is embedded in " + serviceQNames.toString());
		str.append("\nIt embedded following semantic annotations:");
		str.append("\n\tOperation: " + semanticOperation.toString());
		str.append("\n\tInterface: " + semanticOperation.toString());
		str.append("\n\tInput(s): ");
		for(SemanticElement in : semanticInputs){
			str.append("\n\t\t" + in.toString());
		}
		str.append("\n\tOutput(s): ");
		for(SemanticElement out : semanticOutputs){
			str.append("\n\t\t" + out.toString());
		}
		str.append("\n++++++++++++++++++++++");
		return str.toString();
	}

}