/**
 * EasierSBS project - Java file
 * Copyright (C) 2011 EBM WebSourcing - Petals Link
 * 
 * EasierSBS is free project: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * EasierSBS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this program.
 * If not, see <http://www.gnu.org/licenses/lgpl-3.0.txt>.	
 * 
 */ 
package com.petalslink.easiersbs.registry.service.impl.registry;

import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import javax.xml.namespace.QName;

import org.petalslink.abslayer.service.api.Description;

import com.petalslink.easiersbs.registry.service.api.registry.TechnicalServiceRegistry;

/**
 * @author Nicolas Boissel-Dallier - Petals Link
 */
public class TechnicalServiceRegistryImpl implements TechnicalServiceRegistry {


	Map<QName, Description> registry = new HashMap<QName, Description>();
	Map<QName, URL> wsdlUrls = new HashMap<QName, URL>();
	
	public TechnicalServiceRegistryImpl(){
		
	}

	public void addTechnicalService(QName serviceQName, Description wsdlDesc, URL wsdlUrl) {
		registry.put(serviceQName, wsdlDesc);
		wsdlUrls.put(serviceQName, wsdlUrl);
	}

	public void removeTechnicalService(QName serviceQName) {
		registry.remove(serviceQName);
		wsdlUrls.remove(serviceQName);
	}

	public Description getTechnicalService(QName serviceQName) {
		return registry.get(serviceQName);
	}
	
	public URL getWsdlUrl(QName serviceQName){
		return wsdlUrls.get(serviceQName);
	}

	public Set<URL> getWsdlUrls(){
		Set<URL> urls = new HashSet<URL>();
		for(URL url : wsdlUrls.values()){
			urls.add(url);
		}
		return urls;
	}
	
	public Set<Description> getAllTechnicalServices() {
		return new HashSet<Description>(registry.values());
	}

	public void removeAllTechnicalServices() {
		registry.clear();
		wsdlUrls.clear();
	}
	
}