/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiersbs.registry.service.impl.util;

import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectNode;
import com.ebmwebsourcing.easysawsdl10.api.SawsdlHelper;
import com.ebmwebsourcing.easyschema10.api.SchemaHelper;
import com.ebmwebsourcing.easyschema10.api.element.Choice;
import com.ebmwebsourcing.easyschema10.api.element.ComplexType;
import com.ebmwebsourcing.easyschema10.api.element.Element;
import com.ebmwebsourcing.easyschema10.api.element.Sequence;
import com.ebmwebsourcing.easyschema10.api.type.Type;
import com.ebmwebsourcing.easyschema10.api.with.WithElements;
import com.petalslink.easiersbs.registry.service.api.model.SemanticElement;
import com.petalslink.easiersbs.registry.service.api.model.SemanticPart;
import com.petalslink.easiersbs.registry.service.api.model.SemanticProfile;
import com.petalslink.easiersbs.registry.service.impl.model.SemanticElementImpl;
import com.petalslink.easiersbs.registry.service.impl.model.SemanticPartImpl;
import com.petalslink.easiersbs.registry.service.impl.model.SemanticProfileImpl;
import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.petalslink.abslayer.service.api.Description;
import org.petalslink.abslayer.service.api.Endpoint;
import org.petalslink.abslayer.service.api.Interface;
import org.petalslink.abslayer.service.api.Operation;
import org.petalslink.abslayer.service.api.Part;
import org.petalslink.abslayer.service.api.Service;

public class ServiceUtil {
    public static Set<Operation> getOperations(Description description) {
        HashSet<Operation> hashSet = new HashSet<Operation>();
        for (Interface interface_ : description.getInterfaces()) {
            hashSet.addAll(Arrays.asList(interface_.getOperations()));
        }
        return hashSet;
    }

    public static Operation findOperation(QName qName, Description description) {
        for (Interface interface_ : description.getInterfaces()) {
            Operation operation = interface_.getOperation(qName);
            if (operation == null) continue;
            return operation;
        }
        return null;
    }

    public static List<Service> findServicesByOperation(QName qName, Description description) {
        Operation operation = ServiceUtil.findOperation(qName, description);
        List list = description.findServicesImplementingInterface(operation.getParentInterface());
        return list;
    }

    public static Set<Operation> findOperationsByService(QName qName, Description description) {
        HashSet<Operation> hashSet = new HashSet<Operation>();
        Service service = description.findService(qName);
        for (Endpoint endpoint : service.getEndpoints()) {
            hashSet.addAll(Arrays.asList(endpoint.getBinding().getInterface().getOperations()));
        }
        return hashSet;
    }

    public static Set<URI> getFlattenConcepts(Set<SemanticElement> set) {
        HashSet<URI> hashSet = new HashSet<URI>();
        for (SemanticElement semanticElement : set) {
            hashSet.addAll(semanticElement.getSemanticConcepts());
        }
        return hashSet;
    }

    public static SemanticProfile extractSemanticProfile(QName qName, Description description) {
        Service service22;
        SemanticProfileImpl semanticProfileImpl = new SemanticProfileImpl();
        Operation operation = ServiceUtil.findOperation(qName, description);
        semanticProfileImpl.setOperationQName(qName);
        for (Service service22 : ServiceUtil.findServicesByOperation(qName, description)) {
            semanticProfileImpl.addServiceQName(service22.getQName());
        }
        SemanticPart semanticPart = ServiceUtil.extractSemanticPart((XmlObject)operation.getParentInterface().getModel());
        semanticProfileImpl.setSemanticInterface(semanticPart);
        service22 = ServiceUtil.extractSemanticPart((XmlObject)operation.getModel());
        semanticProfileImpl.setSemanticOperation((SemanticPart)service22);
        HashSet<SemanticElement> hashSet = new HashSet<SemanticElement>();
        if (operation.getInput() != null) {
            for (Part part : operation.getInput().getParts()) {
                if (part == null) continue;
                ServiceUtil.extractAllSemanticElements(part, hashSet);
            }
        }
        semanticProfileImpl.setInputSemanticElements(hashSet);
        HashSet<SemanticElement> hashSet2 = new HashSet<SemanticElement>();
        if (operation.getOutput() != null) {
            for (Part part : operation.getOutput().getParts()) {
                if (part == null) continue;
                ServiceUtil.extractAllSemanticElements(part, hashSet2);
            }
        }
        semanticProfileImpl.setOutputSemanticElements(hashSet2);
        return semanticProfileImpl;
    }

    public static SemanticPart extractSemanticPart(XmlObject xmlObject) {
        URI[] uRIArray;
        SemanticPartImpl semanticPartImpl = new SemanticPartImpl();
        for (URI uRI : uRIArray = SawsdlHelper.getModelReference((XmlObject)xmlObject)) {
            semanticPartImpl.addSemanticConcept(uRI);
        }
        return semanticPartImpl;
    }

    public static SemanticElement extractSemanticElement(Element element) {
        URI[] uRIArray;
        SemanticElementImpl semanticElementImpl = new SemanticElementImpl();
        URI[] uRIArray2 = uRIArray = SawsdlHelper.getModelReference((XmlObject)element);
        int n = uRIArray2.length;
        for (int i = 0; i < n; ++i) {
            URI uRI = uRIArray2[i];
            semanticElementImpl.addSemanticConcept(uRI);
        }
        for (URI uRI : uRIArray2 = SawsdlHelper.getModelReference((XmlObject)element.findType())) {
            semanticElementImpl.addSemanticConcept(uRI);
        }
        if (element.getMinOccurs() == 0) {
            semanticElementImpl.setRequired(false);
        } else {
            semanticElementImpl.setRequired(true);
        }
        semanticElementImpl.setElement(element);
        return semanticElementImpl;
    }

    private static void extractAllSemanticElements(Element element, Set<SemanticElement> set) {
        if (element.hasRef()) {
            QName qName = element.getRef();
            Element element2 = SchemaHelper.findElementByQName((XmlObject)element.getXmlObjectBaseRoot(), (QName)qName);
            ServiceUtil.extractAllSemanticElements(element2, set);
        } else {
            SemanticElement semanticElement = ServiceUtil.extractSemanticElement(element);
            if (!set.contains(semanticElement)) {
                set.add(semanticElement);
                Type type = element.findType();
                if (type instanceof ComplexType) {
                    XmlObjectNode[] xmlObjectNodeArray;
                    for (XmlObjectNode xmlObjectNode : xmlObjectNodeArray = type.getXmlObjectChildren()) {
                        ServiceUtil.extractAllSemanticElements(xmlObjectNode, set);
                    }
                }
            }
        }
    }

    private static void extractAllSemanticElements(XmlObjectNode xmlObjectNode, Set<SemanticElement> set) {
        if (xmlObjectNode instanceof WithElements) {
            for (Element element : ((WithElements)xmlObjectNode).getElements()) {
                ServiceUtil.extractAllSemanticElements(element, set);
            }
        }
        if (xmlObjectNode instanceof Sequence || xmlObjectNode instanceof Choice) {
            for (Element element : xmlObjectNode.getXmlObjectChildren()) {
                ServiceUtil.extractAllSemanticElements((XmlObjectNode)element, set);
            }
        }
    }

    private static void extractAllSemanticElements(Part part, Set<SemanticElement> set) {
        Element element = null;
        if (part.getElement() != null) {
            element = part.getElement();
        } else if (part.getType() != null) {
            element = part.createElement();
            element.setName(part.getQName().getLocalPart());
            element.setType(part.getType());
            Type type = SchemaHelper.findTypeByQName((XmlObject)part.getDescription().getModel(), (QName)part.getType());
            SchemaHelper.findParentSchema((XmlObject)type).addElement(element);
        }
        if (element != null) {
            ServiceUtil.extractAllSemanticElements(element, set);
        }
    }
}

