/**
 * EasierSBS project - Java file
 * Copyright (C) 2011 EBM WebSourcing - Petals Link
 * 
 * EasySWS is free project: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * EasySWS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this program.
 * If not, see <http://www.gnu.org/licenses/lgpl-3.0.txt>.	
 * 
 */ 
package com.petalslink.easiersbs.registry.service.impl.model;

import com.ebmwebsourcing.easyschema10.api.element.Element;
import com.petalslink.easiersbs.registry.service.api.model.SemanticElement;


/**
 * @author Nicolas Boissel-Dallier - Petals Link
 */
public class SemanticElementImpl extends SemanticPartImpl implements SemanticElement {

	private boolean required = true;
	private Element element = null;
	
	public SemanticElementImpl(){
		
	}
	
	public boolean isRequired() {
		return required;
	}

	public void setRequired(boolean required) {
		this.required = required;
	}

	public Element getElement() {
		return element;
	}

	public void setElement(Element element) {
		this.element = element;
	}
	
	@Override
	public boolean equals(Object other){
		if(other instanceof SemanticElement 
				&& element != null
				&& ((SemanticElement) other).getElement() != null){
			return (element.inferQName().equals(((SemanticElement) other).getElement().inferQName()));
		} else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		if(element != null){
			return element.inferQName().hashCode();
		}
		return super.hashCode();
	}
	
	@Override
	public String toString(){
		String result = "Element ";
		if(element != null){
			result += element.inferQName();
		}
		 result += " (required:" + required + "): ";
		 result += super.toString();
		return result;
	}
	
}