/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiersbs.registry.service.impl.util;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectNode;
import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easybox.api.XmlObjectReader;
import com.ebmwebsourcing.easybox.api.with.WithName;
import com.ebmwebsourcing.easysawsdl10.api.SawsdlHelper;
import com.ebmwebsourcing.easyschema10.api.SchemaHelper;
import com.ebmwebsourcing.easyschema10.api.element.Choice;
import com.ebmwebsourcing.easyschema10.api.element.ComplexType;
import com.ebmwebsourcing.easyschema10.api.element.Element;
import com.ebmwebsourcing.easyschema10.api.element.Sequence;
import com.ebmwebsourcing.easyschema10.api.type.Type;
import com.ebmwebsourcing.easyschema10.api.with.WithElements;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import com.petalslink.easiersbs.registry.service.api.RegistryException;
import com.petalslink.easiersbs.registry.service.api.model.SemanticElement;
import com.petalslink.easiersbs.registry.service.api.model.SemanticPart;
import com.petalslink.easiersbs.registry.service.api.model.SemanticProfile;
import com.petalslink.easiersbs.registry.service.api.model.generic.GenericElement;
import com.petalslink.easiersbs.registry.service.api.model.generic.GenericPart;
import com.petalslink.easiersbs.registry.service.impl.model.SemanticElementImpl;
import com.petalslink.easiersbs.registry.service.impl.model.SemanticPartImpl;
import com.petalslink.easiersbs.registry.service.impl.model.SemanticProfileImpl;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.Description;
import org.petalslink.abslayer.service.api.Endpoint;
import org.petalslink.abslayer.service.api.Interface;
import org.petalslink.abslayer.service.api.Operation;
import org.petalslink.abslayer.service.api.Part;
import org.petalslink.abslayer.service.api.Service;

public class ServiceUtil {
    public static Set<Operation> getOperations(Description description) {
        HashSet<Operation> hashSet = new HashSet<Operation>();
        for (Interface interface_ : description.getInterfaces()) {
            hashSet.addAll(Arrays.asList(interface_.getOperations()));
        }
        return hashSet;
    }

    public static Operation findOperation(QName qName, Description description) {
        for (Interface interface_ : description.getInterfaces()) {
            Operation operation = interface_.getOperation(qName);
            if (operation == null) continue;
            return operation;
        }
        return null;
    }

    public static List<Service> findServicesByOperation(QName qName, Description description) {
        Operation operation = ServiceUtil.findOperation(qName, description);
        List list = description.findServicesImplementingInterface(operation.getParentInterface());
        return list;
    }

    public static Set<Operation> findOperationsByService(QName qName, Description description) {
        HashSet<Operation> hashSet = new HashSet<Operation>();
        Service service = description.findService(qName);
        for (Endpoint endpoint : service.getEndpoints()) {
            hashSet.addAll(Arrays.asList(endpoint.getBinding().getInterface().getOperations()));
        }
        return hashSet;
    }

    public static <E extends GenericElement<E>> Set<E> getFlattenElements(E e) {
        HashSet hashSet = new HashSet();
        return ServiceUtil.getFlattenElements(e, hashSet);
    }

    private static <E extends GenericElement<E>> Set<E> getFlattenElements(E e, Set<E> set) {
        HashSet<E> hashSet = new HashSet<E>();
        if (e != null) {
            hashSet.add(e);
            set.add(e);
            for (GenericElement genericElement : e.getChildElements()) {
                if (set.contains(genericElement)) continue;
                hashSet.addAll(ServiceUtil.getFlattenElements(genericElement, set));
            }
        }
        return hashSet;
    }

    public static <E extends GenericElement<E>> Set<URI> getFlattenConcepts(Set<E> set) {
        HashSet<URI> hashSet = new HashSet<URI>();
        for (GenericElement genericElement : set) {
            hashSet.addAll(genericElement.getSemanticConcepts());
        }
        return hashSet;
    }

    public static SemanticProfile extractSemanticProfile(QName qName, Description description) {
        Service service2;
        SemanticProfileImpl semanticProfileImpl = new SemanticProfileImpl();
        Operation operation = ServiceUtil.findOperation(qName, description);
        semanticProfileImpl.setOperationQName(qName);
        for (Service service2 : ServiceUtil.findServicesByOperation(qName, description)) {
            semanticProfileImpl.addServiceQName(service2.getQName());
        }
        SemanticPart semanticPart = ServiceUtil.extractSemanticPart((XmlObject)operation.getParentInterface().getModel());
        semanticProfileImpl.setSemanticInterface((GenericPart)semanticPart);
        service2 = ServiceUtil.extractSemanticPart((XmlObject)operation.getModel());
        semanticProfileImpl.setSemanticOperation((GenericPart)service2);
        SemanticElement semanticElement = null;
        if (operation.getInput() != null && operation.getInput().getParts().length != 0 && operation.getInput().getParts()[0] != null) {
            semanticElement = ServiceUtil.extractAllSemanticElements(operation.getInput().getParts()[0]);
        }
        semanticProfileImpl.setInputSemanticElement((GenericElement)semanticElement);
        SemanticElement semanticElement2 = null;
        if (operation.getOutput() != null && operation.getOutput().getParts().length != 0 && operation.getOutput().getParts()[0] != null) {
            semanticElement2 = ServiceUtil.extractAllSemanticElements(operation.getOutput().getParts()[0]);
        }
        semanticProfileImpl.setOutputSemanticElement((GenericElement)semanticElement2);
        return semanticProfileImpl;
    }

    public static SemanticPart extractSemanticPart(XmlObject xmlObject) {
        URI[] uRIArray;
        SemanticPartImpl semanticPartImpl = new SemanticPartImpl();
        if (xmlObject instanceof WithName && ((WithName)xmlObject).hasName()) {
            semanticPartImpl.setName(((WithName)xmlObject).getName());
        }
        for (URI uRI : uRIArray = SawsdlHelper.getModelReference((XmlObject)xmlObject)) {
            semanticPartImpl.addSemanticConcept(uRI);
        }
        return semanticPartImpl;
    }

    public static SemanticElement extractAllSemanticElements(Part part) {
        HashMap<QName, SemanticElement> hashMap = new HashMap<QName, SemanticElement>();
        Element element = null;
        if (part.getElement() != null) {
            element = part.getElement();
        } else if (part.getType() != null) {
            element = part.createElement();
            element.setName(part.getQName().getLocalPart());
            element.setType(part.getType());
            Type type = SchemaHelper.findTypeByQName((XmlObject)part.getDescription().getModel(), (QName)part.getType());
            SchemaHelper.findParentSchema((XmlObject)type).addElement(element);
        }
        if (element != null) {
            return ServiceUtil.extractSemanticElement(element, hashMap);
        }
        return null;
    }

    private static SemanticElement extractSemanticElement(Element element, Map<QName, SemanticElement> map) {
        QName qName = element.inferQName();
        if (map.containsKey(qName)) {
            return map.get(qName);
        }
        if (element.hasRef()) {
            Element element2 = SchemaHelper.findElementByQName((XmlObject)element.getXmlObjectBaseRoot(), (QName)element.getRef());
            return ServiceUtil.extractSemanticElement(element2, map);
        }
        SemanticElementImpl semanticElementImpl = new SemanticElementImpl();
        semanticElementImpl.setElementQName(element.inferQName());
        semanticElementImpl.setName(element.getName());
        if (element.getMinOccurs() == 0) {
            semanticElementImpl.setRequired(false);
        } else {
            semanticElementImpl.setRequired(true);
        }
        for (URI xmlObjectNodeArray : ServiceUtil.extractSemanticAnnotations(element)) {
            semanticElementImpl.addSemanticConcept(xmlObjectNodeArray);
        }
        map.put(qName, semanticElementImpl);
        Type type = element.findType();
        if (type instanceof ComplexType) {
            XmlObjectNode[] xmlObjectNodeArray;
            for (XmlObjectNode xmlObjectNode : xmlObjectNodeArray = type.getXmlObjectChildren()) {
                semanticElementImpl.setChildElements(ServiceUtil.extractSemanticElementChildren(xmlObjectNode, map));
            }
        }
        return semanticElementImpl;
    }

    private static Set<SemanticElement> extractSemanticElementChildren(XmlObjectNode xmlObjectNode, Map<QName, SemanticElement> map) {
        HashSet<SemanticElement> hashSet = new HashSet<SemanticElement>();
        if (xmlObjectNode instanceof WithElements) {
            for (Element element : ((WithElements)xmlObjectNode).getElements()) {
                hashSet.add(ServiceUtil.extractSemanticElement(element, map));
            }
        }
        if (xmlObjectNode instanceof Sequence || xmlObjectNode instanceof Choice) {
            for (Element element : xmlObjectNode.getXmlObjectChildren()) {
                if (element instanceof Element) continue;
                hashSet.addAll(ServiceUtil.extractSemanticElementChildren((XmlObjectNode)element, map));
            }
        }
        return hashSet;
    }

    private static Set<URI> extractSemanticAnnotations(Element element) {
        URI[] uRIArray;
        HashSet<URI> hashSet = new HashSet<URI>();
        URI[] uRIArray2 = uRIArray = SawsdlHelper.getModelReference((XmlObject)element);
        int n = uRIArray2.length;
        for (int i = 0; i < n; ++i) {
            URI uRI = uRIArray2[i];
            hashSet.add(uRI);
        }
        for (URI uRI : uRIArray2 = SawsdlHelper.getModelReference((XmlObject)element.findType())) {
            hashSet.add(uRI);
        }
        return hashSet;
    }

    public static Description getDescription(URL uRL, XmlContext xmlContext) throws RegistryException {
        Definitions definitions = null;
        try {
            XmlObjectReader xmlObjectReader = xmlContext.createReader();
            definitions = (Definitions)xmlObjectReader.readDocument(uRL, Definitions.class);
        }
        catch (XmlObjectReadException xmlObjectReadException) {
            throw new RegistryException("Impossible to parse WSDL file at " + uRL.toString(), (Exception)((Object)xmlObjectReadException));
        }
        return (Description)Factory.getInstance().wrap((XmlObject)definitions);
    }
}

