/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiersbs.registry.service.impl;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlContextFactory;
import com.petalslink.easiersbs.registry.service.api.RegistryException;
import com.petalslink.easiersbs.registry.service.api.SemanticRegistryManager;
import com.petalslink.easiersbs.registry.service.api.model.Operation;
import com.petalslink.easiersbs.registry.service.api.model.Partner;
import com.petalslink.easiersbs.registry.service.api.model.SemanticProfile;
import com.petalslink.easiersbs.registry.service.api.registry.SemanticProfileRegistry;
import com.petalslink.easiersbs.registry.service.api.registry.TechnicalServiceRegistry;
import com.petalslink.easiersbs.registry.service.impl.model.OperationImpl;
import com.petalslink.easiersbs.registry.service.impl.registry.ImportWsdlCallableImpl;
import com.petalslink.easiersbs.registry.service.impl.registry.SemanticProfileRegistryImpl;
import com.petalslink.easiersbs.registry.service.impl.registry.TechnicalServiceRegistryImpl;
import com.petalslink.easiersbs.registry.service.impl.util.ServiceUtil;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.petalslink.abslayer.service.api.Description;
import org.petalslink.abslayer.service.api.Service;

public class SemanticRegistryManagerImpl
implements SemanticRegistryManager {
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private SemanticProfileRegistry profiles = new SemanticProfileRegistryImpl();
    private TechnicalServiceRegistry services = new TechnicalServiceRegistryImpl();
    private static XmlContextFactory xmlContextFactory = new XmlContextFactory();
    private static XmlContext xmlContext = xmlContextFactory.newContext();

    public void addSemanticService(QName qName, Description description, Partner partner, URL uRL) {
        SemanticProfile semanticProfile = ServiceUtil.extractSemanticProfile(qName, description);
        semanticProfile.setPartner(partner);
        List<Service> list = ServiceUtil.findServicesByOperation(qName, description);
        for (Service service : list) {
            this.services.addTechnicalService(service.getQName(), description, uRL);
        }
        this.profiles.addSemanticProfile(semanticProfile);
    }

    public void addSemanticService(QName qName, Description description, URL uRL) {
        this.addSemanticService(qName, description, null, uRL);
    }

    public void addSemanticService(QName qName, URL uRL, Partner partner) throws RegistryException {
        Description description = this.getDescription(uRL);
        this.addSemanticService(qName, description, partner, uRL);
    }

    public void addSemanticService(QName qName, URL uRL) throws RegistryException {
        this.addSemanticService(qName, uRL, null);
    }

    public void addSemanticServices(Description description, Partner partner, URL uRL) {
        for (org.petalslink.abslayer.service.api.Operation operation : ServiceUtil.getOperations(description)) {
            this.addSemanticService(operation.inferQName(), description, partner, uRL);
        }
    }

    public void addSemanticServices(Description description, URL uRL) {
        this.addSemanticServices(description, null, uRL);
    }

    public void addSemanticServices(URL uRL, Partner partner) throws RegistryException {
        Description description = this.getDescription(uRL);
        this.addSemanticServices(description, partner, uRL);
    }

    public void addSemanticServices(URL uRL) throws RegistryException {
        this.addSemanticServices(uRL, null);
    }

    public void addMultipleSemanticServices(Set<URL> set, Partner partner) {
        ExecutorService executorService = Executors.newFixedThreadPool(4);
        ExecutorCompletionService<Boolean> executorCompletionService = new ExecutorCompletionService<Boolean>(executorService);
        HashMap<URL, Future<Boolean>> hashMap = new HashMap<URL, Future<Boolean>>();
        for (URL iterator : set) {
            ImportWsdlCallableImpl importWsdlCallableImpl = new ImportWsdlCallableImpl(this.profiles, this.services, xmlContext, partner, iterator);
            Future<Boolean> future = executorCompletionService.submit(importWsdlCallableImpl);
            hashMap.put(iterator, future);
        }
        boolean bl = false;
        while (!bl) {
            bl = true;
            for (Future future : hashMap.values()) {
                if (future.isDone()) continue;
                bl = false;
                break;
            }
            if (bl) continue;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            try {
                if (((Boolean)((Future)entry.getValue()).get()).booleanValue()) continue;
                this.logger.warning("Impossible to import WSDL at " + entry.getKey());
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
            catch (ExecutionException executionException) {
                throw new RuntimeException(executionException);
            }
        }
        executorService.shutdown();
    }

    public void clearRegistry() {
        this.services.removeAllTechnicalServices();
        this.profiles.removeAllSemanticProfiles();
    }

    public SemanticProfile getSemanticProfile(Operation operation) {
        return this.profiles.getSemanticProfile(operation);
    }

    public Set<SemanticProfile> getAllSemanticProfiles() {
        return this.profiles.getAllSemanticProfiles();
    }

    public Set<SemanticProfile> findSemanticProfilesByPartner(Partner partner) {
        return this.profiles.findSemanticProfilesByPartner(partner);
    }

    public Description getTechnicalService(QName qName) throws RegistryException {
        return this.services.getTechnicalService(qName);
    }

    public URL getWsdlUrl(QName qName) {
        return this.services.getWsdlUrl(qName);
    }

    public Set<URL> getWsdlUrls() {
        return this.services.getWsdlUrls();
    }

    public Set<Description> getAllTechnicalServices() {
        return this.services.getAllTechnicalServices();
    }

    public void removeSemanticServices(Description description) {
        for (Service service : description.getServices()) {
            this.services.removeTechnicalService(service.getQName());
        }
        for (org.petalslink.abslayer.service.api.Operation operation : ServiceUtil.getOperations(description)) {
            QName qName = ServiceUtil.findServicesByOperation(operation.inferQName(), description).get(0).getQName();
            this.profiles.removeSemanticProfile((Operation)new OperationImpl(operation.inferQName(), qName));
        }
    }

    public void removeSemanticService(Operation operation) {
        this.profiles.removeSemanticProfile(operation);
        boolean bl = false;
        Description description = this.services.getTechnicalService(operation.getServiceQName());
        Set<org.petalslink.abslayer.service.api.Operation> set = ServiceUtil.findOperationsByService(operation.getServiceQName(), description);
        for (org.petalslink.abslayer.service.api.Operation operation2 : set) {
            OperationImpl operationImpl = new OperationImpl(operation2.inferQName(), operation.getServiceQName());
            if (this.profiles.getSemanticProfile((Operation)operationImpl) == null) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.services.removeTechnicalService(operation.getServiceQName());
        }
    }

    public void removeSemanticProfilesByPartner(Partner partner) {
        this.profiles.removeSemanticProfilesByPartner(partner);
    }

    public Description getDescription(URL uRL) throws RegistryException {
        return ServiceUtil.getDescription(uRL, xmlContext);
    }
}

