/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiersbs.registry.service.impl.registry;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.petalslink.easiersbs.registry.service.api.model.Partner;
import com.petalslink.easiersbs.registry.service.api.model.SemanticProfile;
import com.petalslink.easiersbs.registry.service.api.registry.SemanticProfileRegistry;
import com.petalslink.easiersbs.registry.service.api.registry.TechnicalServiceRegistry;
import com.petalslink.easiersbs.registry.service.impl.util.ServiceUtil;
import java.net.URL;
import java.util.HashSet;
import java.util.concurrent.Callable;
import javax.xml.namespace.QName;
import org.petalslink.abslayer.service.api.Description;
import org.petalslink.abslayer.service.api.Operation;
import org.petalslink.abslayer.service.api.Service;

public class ImportWsdlCallableImpl
implements Callable<Boolean> {
    private SemanticProfileRegistry profiles;
    private TechnicalServiceRegistry services;
    private XmlContext xmlContext;
    private Partner partner;
    private URL wsdlUrl;

    public ImportWsdlCallableImpl(SemanticProfileRegistry semanticProfileRegistry, TechnicalServiceRegistry technicalServiceRegistry, XmlContext xmlContext, Partner partner, URL uRL) {
        this.profiles = semanticProfileRegistry;
        this.services = technicalServiceRegistry;
        this.xmlContext = xmlContext;
        this.partner = partner;
        this.wsdlUrl = uRL;
    }

    @Override
    public Boolean call() throws Exception {
        try {
            Description description = ServiceUtil.getDescription(this.wsdlUrl, this.xmlContext);
            HashSet<Service> hashSet = new HashSet<Service>();
            for (Operation operation : ServiceUtil.getOperations(description)) {
                QName qName = operation.inferQName();
                SemanticProfile semanticProfile = ServiceUtil.extractSemanticProfile(qName, description);
                semanticProfile.setPartner(this.partner);
                this.profiles.addSemanticProfile(semanticProfile);
                hashSet.addAll(ServiceUtil.findServicesByOperation(qName, description));
            }
            for (Service service : hashSet) {
                this.services.addTechnicalService(service.getQName(), null, this.wsdlUrl);
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }
}

