/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiersbs.registry.service.impl.registry;

import com.petalslink.easiersbs.registry.service.api.model.Operation;
import com.petalslink.easiersbs.registry.service.api.model.Partner;
import com.petalslink.easiersbs.registry.service.api.model.SemanticProfile;
import com.petalslink.easiersbs.registry.service.api.registry.SemanticProfileRegistry;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SemanticProfileRegistryImpl
implements SemanticProfileRegistry {
    Map<Operation, SemanticProfile> registry = new HashMap<Operation, SemanticProfile>();
    Map<Partner, Set<SemanticProfile>> partnerProfiles = new HashMap<Partner, Set<SemanticProfile>>();

    public void addSemanticProfile(SemanticProfile semanticProfile) {
        this.registry.put((Operation)semanticProfile.getOperations().iterator().next(), semanticProfile);
        if (semanticProfile.hasPartner()) {
            Partner partner = semanticProfile.getPartner();
            if (this.partnerProfiles.containsKey(partner)) {
                this.partnerProfiles.get(partner).add(semanticProfile);
            } else {
                HashSet<SemanticProfile> hashSet = new HashSet<SemanticProfile>();
                hashSet.add(semanticProfile);
                this.partnerProfiles.put(partner, hashSet);
            }
        }
    }

    public void removeSemanticProfile(Operation operation) {
        SemanticProfile semanticProfile = this.registry.get(operation);
        if (semanticProfile != null) {
            this.registry.remove(operation);
            if (semanticProfile.hasPartner()) {
                Partner partner = semanticProfile.getPartner();
                Set<SemanticProfile> set = this.partnerProfiles.get(partner);
                set.remove(semanticProfile);
                if (set.isEmpty()) {
                    this.partnerProfiles.remove(partner);
                }
            }
        }
    }

    public SemanticProfile getSemanticProfile(Operation operation) {
        return this.registry.get(operation);
    }

    public Set<SemanticProfile> getAllSemanticProfiles() {
        return new HashSet<SemanticProfile>(this.registry.values());
    }

    public Set<SemanticProfile> findSemanticProfilesByPartner(Partner partner) {
        return this.partnerProfiles.get(partner);
    }

    public void removeAllSemanticProfiles() {
        this.registry.clear();
        this.partnerProfiles.clear();
    }

    public void removeSemanticProfilesByPartner(Partner partner) {
        Set<SemanticProfile> set = this.findSemanticProfilesByPartner(partner);
        for (SemanticProfile semanticProfile : set) {
            this.registry.remove(semanticProfile.getOperations().iterator().next());
        }
        this.partnerProfiles.remove(partner);
    }
}

