/**
 * EasierSBS project - Java file
 * Copyright (C) 2011 EBM WebSourcing - Petals Link
 * 
 * EasierSBS is free project: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * EasierSBS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this program.
 * If not, see <http://www.gnu.org/licenses/lgpl-3.0.txt>.	
 * 
 */ 
package com.petalslink.easiersbs.registry.service.impl.model;

import javax.xml.namespace.QName;

import com.petalslink.easiersbs.registry.service.api.model.Operation;

/**
 * @author Nicolas Boissel-Dallier - Petals Link
 */
public class OperationImpl implements Operation {

	private QName operationQName;
	private QName serviceQName;
	
	public OperationImpl(QName operationQName, QName serviceQName){
		this.operationQName = operationQName;
		this.serviceQName = serviceQName;
	}
	
	
	public QName getOperationQName() {
		return operationQName;
	}

	public void setOperationQName(QName operationQName) {
		this.operationQName = operationQName;
	}


	public QName getServiceQName() {
		return serviceQName;
	}

	public void setServiceQName(QName serviceQName) {
		this.serviceQName = serviceQName;
	}


	@Override
	public String toString(){
		return serviceQName + "::" + operationQName.getLocalPart();
	}
	
	@Override
	public boolean equals(Object other){
		if(other instanceof Operation){
			return (serviceQName.equals(((Operation) other).getServiceQName())
					&& operationQName.equals(((Operation) other).getOperationQName()));
		} else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return serviceQName.hashCode();
	}

}
