package com.petalslink.easiersbs.registry.service.impl.registry;

import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;

import javax.xml.namespace.QName;

import org.petalslink.abslayer.service.api.Description;
import org.petalslink.abslayer.service.api.Operation;
import org.petalslink.abslayer.service.api.Service;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.petalslink.easiersbs.registry.service.api.model.Partner;
import com.petalslink.easiersbs.registry.service.api.model.SemanticProfile;
import com.petalslink.easiersbs.registry.service.api.registry.SemanticProfileRegistry;
import com.petalslink.easiersbs.registry.service.api.registry.TechnicalServiceRegistry;
import com.petalslink.easiersbs.registry.service.impl.util.ServiceUtil;

public class ImportWsdlCallableImpl implements Callable<Boolean> {

	private SemanticProfileRegistry profiles;
	private TechnicalServiceRegistry services;
	private XmlContext xmlContext;
	private Partner partner;
	private URL wsdlUrl;
	
	public ImportWsdlCallableImpl(SemanticProfileRegistry profiles, TechnicalServiceRegistry services, XmlContext xmlContext,
								Partner partner, URL wsdlUrl){
		this.profiles = profiles;
		this.services = services;
		this.xmlContext = xmlContext;
		this.partner = partner;
		this.wsdlUrl = wsdlUrl;
	}
	
	@Override
	public Boolean call() throws Exception {
		try{
			Description wsdlDesc = ServiceUtil.getDescription(wsdlUrl, xmlContext);
			Set<Service> newServices = new HashSet<Service>();
			
			for(Operation op : ServiceUtil.getOperations(wsdlDesc)){
				QName operationQName = op.inferQName();
				SemanticProfile profile = ServiceUtil.extractSemanticProfile(operationQName, wsdlDesc);
				profile.setPartner(partner);
				profiles.addSemanticProfile(profile);
				newServices.addAll(ServiceUtil.findServicesByOperation(operationQName, wsdlDesc));
			}
			
			for(Service service : newServices){
				//TODO: replace null with wsdlDesc
				services.addTechnicalService(service.getQName(), null, wsdlUrl);
			}
		} catch (Exception e) {
			return false;
		} 
		return true;
	}
	
}
