/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiersbs.registry.service.impl.model.generic;

import com.petalslink.easiersbs.registry.service.api.model.Operation;
import com.petalslink.easiersbs.registry.service.api.model.Partner;
import com.petalslink.easiersbs.registry.service.api.model.generic.GenericElement;
import com.petalslink.easiersbs.registry.service.api.model.generic.GenericPart;
import com.petalslink.easiersbs.registry.service.api.model.generic.GenericProfile;
import java.util.HashSet;
import java.util.Set;

public abstract class GenericProfileImpl<P extends GenericPart, E extends GenericElement<E>>
implements GenericProfile<P, E> {
    protected E semanticInput = null;
    protected E semanticOutput = null;
    protected P semanticOperation = null;
    protected P semanticInterface = null;
    protected Set<Operation> operations = new HashSet<Operation>();
    protected Partner partner = null;

    public E getInputSemanticElement() {
        return this.semanticInput;
    }

    public E getOutputSemanticElement() {
        return this.semanticOutput;
    }

    public P getSemanticInterface() {
        return this.semanticInterface;
    }

    public P getSemanticOperation() {
        return this.semanticOperation;
    }

    public void setInputSemanticElement(E e) {
        this.semanticInput = e;
    }

    public void setOutputSemanticElement(E e) {
        this.semanticOutput = e;
    }

    public void setSemanticInterface(P p) {
        this.semanticInterface = p;
    }

    public void setSemanticOperation(P p) {
        this.semanticOperation = p;
    }

    public Set<Operation> getOperations() {
        return this.operations;
    }

    public void addOperation(Operation operation) {
        this.operations.add(operation);
    }

    public void removeOperation(Operation operation) {
        this.operations.remove(operation);
    }

    public Partner getPartner() {
        return this.partner;
    }

    public boolean hasPartner() {
        return this.partner != null;
    }

    public void setPartner(Partner partner) {
        this.partner = partner;
    }

    public boolean equals(Object object) {
        if (object instanceof GenericProfile) {
            return ((Object)this.operations).equals(((GenericProfile)object).getOperations());
        }
        return false;
    }

    public int hashCode() {
        return ((Object)this.operations).hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.semanticOperation != null) {
            stringBuilder.append("\n\tOperation: " + this.semanticOperation.toString());
        }
        if (this.semanticInterface != null) {
            stringBuilder.append("\n\tInterface: " + this.semanticInterface.toString());
        }
        if (this.semanticInput != null) {
            stringBuilder.append("\n\tInput: " + this.semanticInput.toString());
        }
        if (this.semanticOutput != null) {
            stringBuilder.append("\n\tOutput: " + this.semanticOutput.toString());
        }
        return stringBuilder.toString();
    }
}

