/**
 * EasierSBS project - Java file
 * Copyright (C) 2011 EBM WebSourcing - Petals Link
 * 
 * EasySWS is free project: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * EasySWS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this program.
 * If not, see <http://www.gnu.org/licenses/lgpl-3.0.txt>.	
 * 
 */ 
package com.petalslink.easiersbs.matching.service.api;

import com.petalslink.easiersbs.matching.service.api.matcher.HybridMatcher;
import com.petalslink.easiersbs.matching.service.api.matcher.MatcherProperties;
import com.petalslink.easiersbs.matching.service.api.matcher.SemanticMatcher;
import com.petalslink.easiersbs.matching.service.api.matcher.SyntacticMatcher;
import com.petalslink.easiersbs.matching.service.api.matcher.similarity.SimilarityMeasure;
import com.petalslink.easiersbs.matching.service.api.matcher.similarity.SimilarityType;
import com.petalslink.easiersbs.reasoner.api.ReasonerException;
import com.petalslink.easiersbs.reasoner.api.ReasonerFactory;
import com.petalslink.easiersbs.registry.service.api.SemanticRegistryManager;

/**
 * @author Nicolas Boissel-Dallier - Petals Link
 */
public interface SBSFactory {
	
	public HybridMatcher newHybridMatcher(ReasonerFactory reasoner, SemanticRegistryManager registry) throws EasierSBSException, ReasonerException;
	
	public HybridMatcher newHybridMatcher(ReasonerFactory reasoner, SemanticRegistryManager registry, MatcherProperties props) throws EasierSBSException, ReasonerException;
	
	public SyntacticMatcher newSyntacticMatcher(SemanticRegistryManager registry) throws EasierSBSException;
	
	public SyntacticMatcher newSyntacticMatcher(SemanticRegistryManager registry, MatcherProperties props) throws EasierSBSException;
	
	public SemanticMatcher newSemanticMatcher(ReasonerFactory reasoner, SemanticRegistryManager registry) throws ReasonerException;
	
	public SemanticMatcher newSemanticMatcher(ReasonerFactory reasoner, SemanticRegistryManager registry, MatcherProperties props) throws ReasonerException;
	
	public SimilarityMeasure newSimilarityMeasure(SimilarityType type) throws EasierSBSException;
	
	public SimilarityMeasure newSimilarityMeasure(SimilarityType type, int levenshteinLimit) throws EasierSBSException;
	
}
