/**
 * EasierSBS project - Java file
 * Copyright (C) 2011 EBM WebSourcing - Petals Link
 * 
 * EasierSBS is free project: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * EasierSBS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this program.
 * If not, see <http://www.gnu.org/licenses/lgpl-3.0.txt>.	
 * 
 */ 
package com.petalslink.easiersbs.matching.service.matcher;

import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;

import com.petalslink.easiersbs.matching.service.api.matcher.MatchingResult;
import com.petalslink.easiersbs.matching.service.api.profile.SearchProfile;
import com.petalslink.easiersbs.registry.service.api.model.SemanticProfile;

/**
 * @author Nicolas Boissel-Dallier - Petals Link
 */
public class MatchingResultImpl implements MatchingResult {

	
	private Map<SemanticProfile, Double> profiles = new HashMap<SemanticProfile, Double>();
	
	private SearchProfile query;
	
	public MatchingResultImpl(SearchProfile query){
		this.query = query;
	}

	/**
	 * @return the query
	 */
	public SearchProfile getQuery() {
		return query;
	}

	public Map<SemanticProfile, Double> getResultProfiles() {
		return profiles;
	}

	public void addResultProfile(SemanticProfile profile, double rate) {
		profiles.put(profile, rate);
	}

	public void removeResultProfile(SemanticProfile profile) {
		profiles.remove(profile);
	}

	public boolean hasExactProfile() {
		return profiles.containsValue(1.0);
	}

	public boolean hasCorrectProfile(double acceptanceThreshold) {
		for(double d : profiles.values()){
			if(d > acceptanceThreshold) {
				return true;
			}
		}
		return false;
	}

	public SemanticProfile getBestProfile() {
		SemanticProfile res = null;
		Double best = 0.0;
		for(Entry<SemanticProfile, Double> entry : profiles.entrySet()){
			if(res == null || entry.getValue() > best){
				res = entry.getKey();
				best = entry.getValue();
			}
		}
		return res;
	}

}
