/**
 * EasierSBS project - Java file
 * Copyright (C) 2011 EBM WebSourcing - Petals Link
 * 
 * EasySWS is free project: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * EasySWS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this program.
 * If not, see <http://www.gnu.org/licenses/lgpl-3.0.txt>.	
 * 
 */ 
package com.petalslink.easiersbs.matching.service.profile.infered;

import java.util.HashSet;
import java.util.Set;

import com.petalslink.easiersbs.matching.service.api.profile.infered.InferedElement;
import com.petalslink.easiersbs.matching.service.api.profile.infered.InferedPart;
import com.petalslink.easiersbs.matching.service.api.profile.infered.InferedSearchProfile;


/**
 * @author Nicolas Boissel-Dallier - Petals Link
 */
public class InferedSearchProfileImpl implements InferedSearchProfile {

	private Set<InferedElement> semanticInputs = new HashSet<InferedElement>();
	private Set<InferedElement> semanticOutputs = new HashSet<InferedElement>();
	private InferedPart semanticOperation = null;
	private InferedPart semanticInterface = null;
	
	public InferedSearchProfileImpl(){
		
	}
	
	public InferedSearchProfileImpl(
			InferedPart semanticInterface, InferedPart semanticOperation, 
			Set<InferedElement> semanticInputs, Set<InferedElement> semanticOutputs){
		this.semanticInterface = semanticInterface;
		this.semanticOperation = semanticOperation;
		this.semanticInputs = semanticInputs;
		this.semanticOutputs = semanticOutputs;
	}

	/* (non-Javadoc)
	 * @see com.petalslink.easiersbs.matching.service.api.profile.InferedSimpleProfile#addInputSemanticElement(com.petalslink.easiersbs.matching.service.api.profile.InferedSemanticElement)
	 */
	@Override
	public void addInputSemanticElement(InferedElement semanticInput) {
		semanticInputs.add(semanticInput);
	}

	/* (non-Javadoc)
	 * @see com.petalslink.easiersbs.matching.service.api.profile.InferedSimpleProfile#addOutputSemanticElement(com.petalslink.easiersbs.matching.service.api.profile.InferedSemanticElement)
	 */
	@Override
	public void addOutputSemanticElement(InferedElement semanticOutput) {
		semanticOutputs.add(semanticOutput);
	}

	/* (non-Javadoc)
	 * @see com.petalslink.easiersbs.matching.service.api.profile.InferedSimpleProfile#getInputSemanticElements()
	 */
	@Override
	public Set<InferedElement> getInputSemanticElements() {
		return semanticInputs;
	}

	/* (non-Javadoc)
	 * @see com.petalslink.easiersbs.matching.service.api.profile.InferedSimpleProfile#getOutputSemanticElements()
	 */
	@Override
	public Set<InferedElement> getOutputSemanticElements() {
		return semanticOutputs;
	}

	/* (non-Javadoc)
	 * @see com.petalslink.easiersbs.matching.service.api.profile.InferedSimpleProfile#getSemanticInterface()
	 */
	@Override
	public InferedPart getSemanticInterface() {
		return semanticInterface;
	}

	/* (non-Javadoc)
	 * @see com.petalslink.easiersbs.matching.service.api.profile.InferedSimpleProfile#getSemanticOperation()
	 */
	@Override
	public InferedPart getSemanticOperation() {
		return semanticOperation;
	}

	/* (non-Javadoc)
	 * @see com.petalslink.easiersbs.matching.service.api.profile.InferedSimpleProfile#removeInputSemanticElement(com.petalslink.easiersbs.matching.service.api.profile.InferedSemanticElement)
	 */
	@Override
	public void removeInputSemanticElement(InferedElement semanticInput) {
		semanticInputs.remove(semanticInput);
	}

	/* (non-Javadoc)
	 * @see com.petalslink.easiersbs.matching.service.api.profile.InferedSimpleProfile#removeOutputSemanticElement(com.petalslink.easiersbs.matching.service.api.profile.InferedSemanticElement)
	 */
	@Override
	public void removeOutputSemanticElement(InferedElement semanticOutput) {
		semanticOutputs.remove(semanticOutput);
	}

	/* (non-Javadoc)
	 * @see com.petalslink.easiersbs.matching.service.api.profile.InferedSimpleProfile#setSemanticInterface(com.petalslink.easiersbs.matching.service.api.profile.InferedSemanticPart)
	 */
	@Override
	public void setSemanticInterface(InferedPart semanticInterface) {
		this.semanticInterface = semanticInterface;
	}

	/* (non-Javadoc)
	 * @see com.petalslink.easiersbs.matching.service.api.profile.InferedSimpleProfile#setSemanticOperation(com.petalslink.easiersbs.matching.service.api.profile.InferedSemanticPart)
	 */
	@Override
	public void setSemanticOperation(InferedPart semanticOperation) {
		this.semanticOperation = semanticOperation;
	}
	
	@Override
	public String toString(){
		StringBuilder str = new StringBuilder();
		str.append("++++++++++++++++++++++");
		str.append("\nSearchProfile:");
		str.append("\n\tOperation: " + semanticOperation.toString());
		str.append("\n\tInterface: " + semanticOperation.toString());
		str.append("\n\tInput(s): ");
		for(InferedElement in : semanticInputs){
			str.append("\n\t\t" + in.toString());
		}
		str.append("\n\tOutput(s): ");
		for(InferedElement out : semanticOutputs){
			str.append("\n\t\t" + out.toString());
		}
		str.append("\n++++++++++++++++++++++");
		return str.toString();
	}
	
}