/**
 * EasierSBS project - Java file
 * Copyright (C) 2011 EBM WebSourcing - Petals Link
 * 
 * EasySWS is free project: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * EasySWS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this program.
 * If not, see <http://www.gnu.org/licenses/lgpl-3.0.txt>.	
 * 
 */ 
package com.petalslink.easiersbs.matching.service.profile.infered;

import java.util.Set;

import com.petalslink.easiersbs.matching.service.api.profile.infered.InferedElement;
import com.petalslink.easiersbs.matching.service.api.profile.infered.InferedSemanticConcept;


/**
 * @author Nicolas Boissel-Dallier - Petals Link
 */
public class InferedSemanticElementImpl extends InferedSemanticPartImpl implements InferedElement {

	private boolean required = true;
	
	public InferedSemanticElementImpl(){
		super();
	}
	
	public InferedSemanticElementImpl(Set<InferedSemanticConcept> semanticConcepts){
		super(semanticConcepts);
	}
	
	public InferedSemanticElementImpl(Set<InferedSemanticConcept> semanticConcepts, boolean required){
		super(semanticConcepts);
		this.required = required;
	}
	
	/* (non-Javadoc)
	 * @see com.petalslink.easiersbs.matching.service.api.profile.InferedSemanticElement#isRequired()
	 */
	@Override
	public boolean isRequired() {
		return required;
	}

	/* (non-Javadoc)
	 * @see com.petalslink.easiersbs.matching.service.api.profile.InferedSemanticElement#setRequired(boolean)
	 */
	@Override
	public void setRequired(boolean required) {
		this.required = required;
	}
	
	@Override
	public String toString(){
		return super.toString();
	}
	
}