/**
 * EasierSBS project - Java file
 * Copyright (C) 2011 EBM WebSourcing - Petals Link
 * 
 * EasySWS is free project: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * EasySWS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this program.
 * If not, see <http://www.gnu.org/licenses/lgpl-3.0.txt>.	
 * 
 */ 
package com.petalslink.easiersbs.matching.service.profile.infered;

import java.net.URI;
import java.net.URISyntaxException;

import com.petalslink.easiersbs.matching.service.api.profile.infered.RatedURI;


/**
 * @author Nicolas Boissel-Dallier - Petals Link
 */
public class RatedURIImpl implements RatedURI {

	
	private URI concept = null;
	private double rate = 1.0;
	
	public RatedURIImpl(URI concept) {
		this.concept = concept;
	}
	
	public RatedURIImpl(URI concept, double rate) {
		this.concept = concept;
		this.rate = rate;
	}
	
	public RatedURIImpl(String str) throws URISyntaxException {
		this.concept = new URI(str);
	}
	
	public RatedURIImpl(String str, double rate) throws URISyntaxException {
		this.concept = new URI(str);
		this.rate = rate;
	}

	/* (non-Javadoc)
	 * @see java.lang.Comparable#compareTo(java.lang.Object)
	 */
	@Override
	public int compareTo(RatedURI other) {
		return ((Double)this.rate).compareTo(other.getRate());
	}

	/* (non-Javadoc)
	 * @see com.petalslink.easiersbs.matching.service.api.profile.RatedSemanticConcept#getRate()
	 */
	@Override
	public double getRate() {
		return rate;
	}

	/* (non-Javadoc)
	 * @see com.petalslink.easiersbs.matching.service.api.profile.RatedSemanticConcept#setRate(double)
	 */
	@Override
	public void setRate(double rate) {
		this.rate = rate;
	}
	
	/**
	 * @return the concept
	 */
	public URI getConcept() {
		return concept;
	}

	/**
	 * @param concept the concept to set
	 */
	public void setConcept(URI concept) {
		this.concept = concept;
	}

	@Override
	public boolean equals(Object ob) {
		if(ob instanceof RatedURI){
			return concept.equals(((RatedURI) ob).getConcept());
		} else if(ob instanceof URI){
			return concept.equals(ob);
		} else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return concept.hashCode();
	}
	
	public String toString(){
		return concept.toString() + " (rate=" + rate + ")";
	}
	
}
