/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiersbs.matching.service.matcher;

import com.petalslink.easiersbs.matching.service.api.matcher.MatcherProperties;
import com.petalslink.easiersbs.matching.service.api.matcher.similarity.SimilarityType;
import java.util.Properties;

public class MatcherPropertiesImpl
implements MatcherProperties {
    private double operationWeight = 0.5;
    private double semanticWeight = 0.75;
    private double semanticAcceptanceThreshold = 0.2;
    private double syntacticAcceptanceThreshold = 0.2;
    private double exactMark = 1.0;
    private double pluginMark = 0.9;
    private double subsumeMark = 0.5;
    private double equivalentMark = 0.9;
    private double specializationMark = 0.6;
    private double generalizationMark = 0.3;
    private int levenshteinLimit = 1;
    private SimilarityType similarityType = SimilarityType.JENSEN_SHANNON;

    public MatcherPropertiesImpl() {
    }

    public MatcherPropertiesImpl(Properties properties) {
        for (Object object : properties.keySet()) {
            String string = object.toString().trim();
            if ("easiersbs.general.operation.weight".equals(string)) {
                this.setOperationWeight(Double.parseDouble(properties.get(string).toString().trim()));
                continue;
            }
            if ("easiersbs.hybrid.semantic.weight".equals(string)) {
                this.setSemanticWeight(Double.parseDouble(properties.get(string).toString().trim()));
                continue;
            }
            if ("easiersbs.semantic.acceptance.threshold".equals(string)) {
                this.setSemanticThreshold(Double.parseDouble(properties.get(string).toString().trim()));
                continue;
            }
            if ("easiersbs.syntactic.acceptance.threshold".equals(string)) {
                this.setSyntacticThreshold(Double.parseDouble(properties.get(string).toString().trim()));
                continue;
            }
            if ("easiersbs.semantic.exact.mark".equals(string)) {
                this.setExactMark(Double.parseDouble(properties.get(string).toString().trim()));
                continue;
            }
            if ("easiersbs.semantic.plugin.mark".equals(string)) {
                this.setPluginMark(Double.parseDouble(properties.get(string).toString().trim()));
                continue;
            }
            if ("easiersbs.semantic.subsume.mark".equals(string)) {
                this.setSubsumeMark(Double.parseDouble(properties.get(string).toString().trim()));
                continue;
            }
            if ("easiersbs.semantic.equivalent.concept.mark".equals(string)) {
                this.setSubsumeMark(Double.parseDouble(properties.get(string).toString().trim()));
                continue;
            }
            if ("easiersbs.semantic.specialization.concept.mark".equals(string)) {
                this.setSpecializationMark(Double.parseDouble(properties.get(string).toString().trim()));
                continue;
            }
            if ("easiersbs.semantic.generalization.concept.mark".equals(string)) {
                this.setGeneralizationMark(Double.parseDouble(properties.get(string).toString().trim()));
                continue;
            }
            if ("easiersbs.syntactic.levenshtein.limit".equals(string)) {
                this.setLevenshteinLimit(Integer.parseInt(properties.get(string).toString().trim()));
                continue;
            }
            if (!"easiersbs.syntactic.similarity.type".equals(string)) continue;
            this.setSimilarityType(SimilarityType.valueOf((String)properties.get(string).toString().trim()));
        }
    }

    public double getEquivalentMark() {
        return this.equivalentMark;
    }

    public double getExactMark() {
        return this.exactMark;
    }

    public double getGeneralizationMark() {
        return this.generalizationMark;
    }

    public double getInputOutputWeigth() {
        return 1.0 - this.operationWeight;
    }

    public int getLevenshteinLimit() {
        return this.levenshteinLimit;
    }

    public double getOperationWeight() {
        return this.operationWeight;
    }

    public double getPluginMark() {
        return this.pluginMark;
    }

    public double getSemanticAcceptanceThreshold() {
        return this.semanticAcceptanceThreshold;
    }

    public double getSemanticThreshold() {
        return this.semanticAcceptanceThreshold;
    }

    public double getSemanticWeight() {
        return this.semanticWeight;
    }

    public SimilarityType getSimilarityType() {
        return this.similarityType;
    }

    public double getSpecializationMark() {
        return this.specializationMark;
    }

    public double getSubsumeMark() {
        return this.subsumeMark;
    }

    public double getSyntacticAcceptanceThreshold() {
        return this.syntacticAcceptanceThreshold;
    }

    public double getSyntacticThreshold() {
        return this.syntacticAcceptanceThreshold;
    }

    public double getSyntacticWeigth() {
        return 1.0 - this.semanticWeight;
    }

    public void setEquivalentMark(double d) {
        this.equivalentMark = d;
    }

    public void setExactMark(double d) {
        this.exactMark = this.norm(d);
    }

    public void setGeneralizationMark(double d) {
        this.generalizationMark = d;
    }

    public void setLevenshteinLimit(int n) {
        this.levenshteinLimit = n;
    }

    public void setOperationWeight(double d) {
        this.operationWeight = this.norm(d);
    }

    public void setPluginMark(double d) {
        this.pluginMark = this.norm(d);
    }

    public void setSemanticAcceptanceThreshold(double d) {
        this.semanticAcceptanceThreshold = d;
    }

    public void setSemanticThreshold(double d) {
        this.semanticAcceptanceThreshold = this.norm(d);
    }

    public void setSemanticWeight(double d) {
        this.semanticWeight = this.norm(d);
    }

    public void setSimilarityType(SimilarityType similarityType) {
        if (similarityType != null) {
            this.similarityType = similarityType;
        }
    }

    public void setSpecializationMark(double d) {
        this.specializationMark = d;
    }

    public void setSubsumeMark(double d) {
        this.subsumeMark = this.norm(d);
    }

    public void setSyntacticAcceptanceThreshold(double d) {
        this.syntacticAcceptanceThreshold = d;
    }

    public void setSyntacticThreshold(double d) {
        this.syntacticAcceptanceThreshold = this.norm(d);
    }

    private double norm(double d) {
        if (d > 1.0) {
            return 1.0;
        }
        if (d < 0.0) {
            return 0.0;
        }
        return d;
    }
}

