/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiersbs.matching.service.matcher;

import com.petalslink.easiersbs.matching.service.api.matcher.MatcherProperties;
import com.petalslink.easiersbs.matching.service.api.matcher.MatchingResult;
import com.petalslink.easiersbs.matching.service.api.matcher.SemanticMatcher;
import com.petalslink.easiersbs.matching.service.api.profile.SearchProfile;
import com.petalslink.easiersbs.matching.service.api.profile.infered.InferedSearchProfile;
import com.petalslink.easiersbs.matching.service.matcher.AbstractMatcherImpl;
import com.petalslink.easiersbs.matching.service.matcher.MatcherPropertiesImpl;
import com.petalslink.easiersbs.matching.service.matcher.MatchingResultImpl;
import com.petalslink.easiersbs.matching.service.util.SimilarityUtil;
import com.petalslink.easiersbs.reasoner.api.ReasonerException;
import com.petalslink.easiersbs.reasoner.api.ReasonerFactory;
import com.petalslink.easiersbs.reasoner.api.engine.Reasoner;
import com.petalslink.easiersbs.reasoner.api.ontology.OntologyManager;
import com.petalslink.easiersbs.registry.service.api.SemanticRegistryManager;
import com.petalslink.easiersbs.registry.service.api.model.SemanticProfile;
import java.util.Set;

public class SemanticMatcherImpl
extends AbstractMatcherImpl
implements SemanticMatcher {
    private Reasoner reasoner = null;
    private OntologyManager manager = null;

    public SemanticMatcherImpl(ReasonerFactory reasonerFactory, SemanticRegistryManager semanticRegistryManager, MatcherProperties matcherProperties) throws ReasonerException {
        this.registry = semanticRegistryManager;
        this.props = matcherProperties;
        this.manager = reasonerFactory.getOntologyManager();
        this.reasoner = reasonerFactory.newReasoner(this.manager);
    }

    public SemanticMatcherImpl(ReasonerFactory reasonerFactory, SemanticRegistryManager semanticRegistryManager) throws ReasonerException {
        this(reasonerFactory, semanticRegistryManager, new MatcherPropertiesImpl());
    }

    public Reasoner getReasoner() {
        return this.reasoner;
    }

    public OntologyManager getOntologyManager() {
        return this.manager;
    }

    @Override
    public MatchingResult findServices(SearchProfile searchProfile, Set<SemanticProfile> set) {
        MatchingResultImpl matchingResultImpl = new MatchingResultImpl(searchProfile);
        InferedSearchProfile inferedSearchProfile = searchProfile.infer(this.reasoner, this.props);
        for (SemanticProfile semanticProfile : set) {
            double d = SimilarityUtil.measureSemanticSimilarity(inferedSearchProfile.getSemanticInterface().getInferedSemanticConcepts(), semanticProfile.getSemanticInterface().getSemanticConcepts());
            double d2 = SimilarityUtil.measureSemanticSimilarity(inferedSearchProfile.getSemanticOperation().getInferedSemanticConcepts(), semanticProfile.getSemanticOperation().getSemanticConcepts());
            double d3 = SimilarityUtil.measureElementSimilarity(inferedSearchProfile.getInputSemanticElements(), semanticProfile.getInputSemanticElements(), this.props);
            double d4 = SimilarityUtil.measureElementSimilarity(inferedSearchProfile.getOutputSemanticElements(), semanticProfile.getOutputSemanticElements(), this.props);
            double d5 = (d + d2) / 2.0 * this.props.getOperationWeight() + (d3 + d4) / 2.0 * this.props.getInputOutputWeigth();
            if (!(d5 > this.props.getSemanticThreshold())) continue;
            matchingResultImpl.addResultProfile(semanticProfile, d5);
        }
        return matchingResultImpl;
    }
}

