/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiersbs.matching.service.matcher.similarity;

import com.petalslink.easiersbs.matching.service.api.matcher.similarity.SimilarityMeasure;
import com.petalslink.easiersbs.matching.service.matcher.similarity.DoubleVector;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractSimilarityMeasureImpl
implements SimilarityMeasure {
    protected static Logger logger = Logger.getLogger(AbstractSimilarityMeasureImpl.class.getName());
    private int levenshteinLimit = 0;

    protected Map<String, Integer> countWordFrequency(List<String> list) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (String string : list) {
            if (hashMap.containsKey(string)) {
                hashMap.put(string, (Integer)hashMap.get(string) + 1);
                continue;
            }
            boolean bl = false;
            if (this.levenshteinLimit > 0 && string.length() > 3 && string.length() < 12) {
                for (String string2 : hashMap.keySet()) {
                    if (StringUtils.getLevenshteinDistance((String)string2, (String)string) > this.levenshteinLimit) continue;
                    hashMap.put(string2, (Integer)hashMap.get(string2) + 1);
                    bl = true;
                }
            }
            if (bl) continue;
            hashMap.put(string, 1);
        }
        return hashMap;
    }

    protected DoubleVector getProperVectors(Map<String, Integer> map, Map<String, Integer> map2) {
        HashSet<String> hashSet = new HashSet<String>();
        Map<String, String> map3 = null;
        for (String object2 : map.keySet()) {
            hashSet.add(object2);
        }
        if (this.levenshteinLimit > 0) {
            map3 = this.getCloseWords(map.keySet(), map2.keySet());
            for (String string : map2.keySet()) {
                if (map3.containsKey(string)) continue;
                hashSet.add(string);
            }
        } else {
            for (String string : map2.keySet()) {
                hashSet.add(string);
            }
        }
        Object object3 = new int[hashSet.size()];
        int[] nArray = new int[hashSet.size()];
        int n = 0;
        for (String string : hashSet) {
            object3[n] = map.containsKey(string) ? (Object)map.get(string) : (Object)false;
            if (this.levenshteinLimit > 0 && map3.containsValue(string)) {
                for (Map.Entry<String, String> entry : map3.entrySet()) {
                    if (!entry.getValue().equals(string)) continue;
                    int n2 = n;
                    nArray[n2] = nArray[n2] + map2.get(entry.getKey());
                }
            } else {
                nArray[n] = map2.containsKey(string) ? map2.get(string) : 0;
            }
            ++n;
        }
        return new DoubleVector((int[])object3, nArray);
    }

    private Map<String, String> getCloseWords(Set<String> set, Set<String> set2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        block0: for (String string : set) {
            for (String string2 : set2) {
                if (string.length() >= 12 || string2.length() >= 12 || StringUtils.getLevenshteinDistance((String)string, (String)string2) > this.levenshteinLimit) continue;
                hashMap.put(string2, string);
                continue block0;
            }
        }
        return hashMap;
    }

    public int getLevenshteinLimit() {
        return this.levenshteinLimit;
    }

    public void setLevenshteinLimit(int n) {
        this.levenshteinLimit = n > 2 ? 2 : n;
    }
}

