/**
 * EasierSBS project - Java file
 * Copyright (C) 2011 EBM WebSourcing - Petals Link
 * 
 * EasySWS is free project: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * EasySWS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this program.
 * If not, see <http://www.gnu.org/licenses/lgpl-3.0.txt>.	
 * 
 */ 
package com.petalslink.easiersbs.matching.service;

import java.net.URI;
import java.util.Set;

import com.petalslink.easiersbs.matching.service.api.ProfileFactory;
import com.petalslink.easiersbs.matching.service.api.profile.Element;
import com.petalslink.easiersbs.matching.service.api.profile.Part;
import com.petalslink.easiersbs.matching.service.api.profile.SearchProfile;
import com.petalslink.easiersbs.matching.service.profile.ElementImpl;
import com.petalslink.easiersbs.matching.service.profile.PartImpl;
import com.petalslink.easiersbs.matching.service.profile.SearchProfileImpl;
import com.petalslink.easiersbs.registry.service.api.model.Partner;
import com.petalslink.easiersbs.registry.service.api.model.SemanticProfile;
import com.petalslink.easiersbs.registry.service.impl.model.PartnerImpl;



/**
 * @author Nicolas Boissel-Dallier - Petals Link
 */
public class ProfileFactoryImpl implements ProfileFactory {

	private static ProfileFactory instance = new ProfileFactoryImpl();
	
	private ProfileFactoryImpl(){
		
	}
	
	public static ProfileFactory getInstance(){
		return instance;
	}
	
	
	/* Factory methods */
	public Element newSemanticElement() {
		return new ElementImpl();
	}

	public Element newSemanticElement(Set<URI> URIs,
			boolean isRequired) {
		return new ElementImpl(URIs, isRequired);
	}

	public Part newSemanticPart() {
		return new PartImpl();
	}

	public Part newSemanticPart(Set<URI> URIs) {
		return new PartImpl(URIs);
	}

	public SearchProfile newSearchProfile() {
		return new SearchProfileImpl();
	}

	public SearchProfile newSearchProfile(Part semanticInterface,
			Part semanticOperation, Set<Element> semanticInputs, 
			Set<Element> semanticOutputs) {
		return new SearchProfileImpl(semanticInterface, semanticOperation, semanticInputs, semanticOutputs);
	}
	
	public SearchProfile newSearchProfile(SemanticProfile profile){
		return new SearchProfileImpl(profile);
	}
	
	public Partner newPartner(String name){
		return new PartnerImpl(name);
	}

}
