package com.petalslink.easiersbs.matching.service.matcher.computation;

import java.util.List;
import java.util.concurrent.Callable;

import com.petalslink.easiersbs.matching.service.api.matcher.MatcherProperties;
import com.petalslink.easiersbs.matching.service.api.matcher.similarity.SimilarityMeasure;
import com.petalslink.easiersbs.matching.service.util.SimilarityUtil;
import com.petalslink.easiersbs.registry.service.api.model.SemanticProfile;

public class SyntacticComputationImpl implements Callable<Double> {

	private MatcherProperties props;
	private SimilarityMeasure similarity;
	private List<String> functionalWords;
	private List<String> inputWords;
	private List<String> outputWords;
	private SemanticProfile service;

	
	public SyntacticComputationImpl(MatcherProperties props, SimilarityMeasure similarity,
							List<String> functionalWords, List<String> inputWords, 
							List<String> outputWords, SemanticProfile targetService){
		this.props = props;
		this.similarity = similarity;
		this.functionalWords = functionalWords;
		this.inputWords = inputWords;
		this.outputWords = outputWords;
		this.service = targetService;
	}
	
	@Override
	public Double call() throws Exception {
		double finalRate = 0.0;
		Double ioRate = null;
		Double funcRate = null;
		
		if(props.getOperationWeight() != 0.0){
			List<String> serviceFunctionalWords = SimilarityUtil.extractUriRelatedWords(service.getSemanticOperation().getSemanticConcepts());
			serviceFunctionalWords.addAll(SimilarityUtil.extractUriRelatedWords(service.getSemanticInterface().getSemanticConcepts()));
			
			funcRate = similarity.measureSimilarity(functionalWords, serviceFunctionalWords);
		}
		
		if(props.getInputOutputWeigth() != 0.0){
			List<String> serviceInputWords = SimilarityUtil.extractElementRelatedWords(service.getInputSemanticElements());
			double iRate = similarity.measureSimilarity(inputWords, serviceInputWords);

			List<String> serviceOutputWords = SimilarityUtil.extractElementRelatedWords(service.getOutputSemanticElements());
			double oRate = similarity.measureSimilarity(outputWords, serviceOutputWords);

			ioRate = (iRate + oRate) / 2.0;
		}
		
		// If one weight is set to 0, we only consider the other one
		if(ioRate == null || ioRate.isNaN()){
			finalRate = funcRate;
		} else if(funcRate == null || funcRate.isNaN()){
			finalRate = ioRate;
		} else {
			finalRate = (ioRate * props.getInputOutputWeigth()) + (funcRate * props.getOperationWeight());
		}
		
		return finalRate;
	}

}
