/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiersbs.matching.service.matcher.computation;

import com.petalslink.easiersbs.matching.service.api.matcher.MatcherProperties;
import com.petalslink.easiersbs.matching.service.api.matcher.similarity.SimilarityMeasure;
import com.petalslink.easiersbs.matching.service.util.SimilarityUtil;
import com.petalslink.easiersbs.registry.service.api.model.SemanticProfile;
import java.util.List;
import java.util.concurrent.Callable;

public class SyntacticComputationImpl
implements Callable<Double> {
    private MatcherProperties props;
    private SimilarityMeasure similarity;
    private List<String> functionalWords;
    private List<String> inputWords;
    private List<String> outputWords;
    private SemanticProfile service;

    public SyntacticComputationImpl(MatcherProperties matcherProperties, SimilarityMeasure similarityMeasure, List<String> list, List<String> list2, List<String> list3, SemanticProfile semanticProfile) {
        this.props = matcherProperties;
        this.similarity = similarityMeasure;
        this.functionalWords = list;
        this.inputWords = list2;
        this.outputWords = list3;
        this.service = semanticProfile;
    }

    @Override
    public Double call() throws Exception {
        List<String> list;
        double d = 0.0;
        Double d2 = null;
        Double d3 = null;
        if (this.props.getOperationWeight() != 0.0) {
            list = SimilarityUtil.extractUriRelatedWords(this.service.getSemanticOperation().getSemanticConcepts());
            list.addAll(SimilarityUtil.extractUriRelatedWords(this.service.getSemanticInterface().getSemanticConcepts()));
            d3 = this.similarity.measureSimilarity(this.functionalWords, list);
        }
        if (this.props.getInputOutputWeigth() != 0.0) {
            list = SimilarityUtil.extractElementRelatedWords(this.service.getInputSemanticElements());
            double d4 = this.similarity.measureSimilarity(this.inputWords, list);
            List<String> list2 = SimilarityUtil.extractElementRelatedWords(this.service.getOutputSemanticElements());
            double d5 = this.similarity.measureSimilarity(this.outputWords, list2);
            d2 = (d4 + d5) / 2.0;
        }
        d = d2 == null || d2.isNaN() ? d3 : (d3 == null || d3.isNaN() ? d2 : d2 * this.props.getInputOutputWeigth() + d3 * this.props.getOperationWeight());
        return d;
    }
}

