/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiersbs.matching.service.util;

import com.petalslink.easiersbs.matching.service.api.profile.infered.InferedElement;
import com.petalslink.easiersbs.matching.service.api.profile.infered.InferedSemanticConcept;
import com.petalslink.easiersbs.matching.service.api.profile.infered.RatedURI;
import com.petalslink.easiersbs.matching.service.profile.infered.RatedURIImpl;
import com.petalslink.easiersbs.matching.service.util.VectorUtil;
import com.petalslink.easiersbs.registry.service.api.model.SemanticElement;
import com.petalslink.easiersbs.registry.service.api.model.SemanticPart;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class SimilarityUtil {
    public static List<String> extractElementRelatedWords(Set<? extends SemanticPart> set) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (SemanticPart semanticPart : set) {
            if (semanticPart.getName() != null) {
                arrayList.addAll(SimilarityUtil.splitInWords(semanticPart.getName()));
            }
            if (semanticPart.getSemanticConcepts().isEmpty()) continue;
            arrayList.addAll(SimilarityUtil.extractUriRelatedWords(semanticPart.getSemanticConcepts()));
        }
        return arrayList;
    }

    public static List<String> extractUriRelatedWords(Set<URI> set) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (URI uRI : set) {
            String string = uRI.getFragment();
            if (string == null) continue;
            arrayList.addAll(SimilarityUtil.splitInWords(string));
        }
        return arrayList;
    }

    public static List<String> splitInWords(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : string.split("(?=[A-Z][a-z]+)|[-_0-9\\s]")) {
            if (string2.isEmpty()) continue;
            arrayList.add(string2.toLowerCase());
        }
        return arrayList;
    }

    public static double measureSemanticSimilarity(Set<InferedSemanticConcept> set, Set<URI> set2) {
        double d = 0.0;
        if (!set.isEmpty() && !set2.isEmpty()) {
            double d2 = 0.0;
            for (InferedSemanticConcept inferedSemanticConcept : set) {
                Set set3 = inferedSemanticConcept.getRatedSemanticConcepts();
                double d3 = 0.0;
                block1: for (URI uRI : set2) {
                    RatedURIImpl ratedURIImpl = new RatedURIImpl(uRI);
                    if (!set3.contains(ratedURIImpl)) continue;
                    for (RatedURI ratedURI : set3) {
                        if (!ratedURI.equals(ratedURIImpl)) continue;
                        d3 = Math.max(d3, ratedURI.getRate());
                        continue block1;
                    }
                }
                d2 += d3;
            }
            d = d2 / (double)set.size();
        }
        return d;
    }

    public static double measureElementSimilarity(Set<InferedElement> set, Set<SemanticElement> set2, double d, double d2) {
        if (!set.isEmpty() && !set2.isEmpty()) {
            boolean bl = false;
            HashMap<InferedElement, Double> hashMap = new HashMap<InferedElement, Double>();
            for (InferedElement inferedElement : set) {
                hashMap.put(inferedElement, 0.0);
            }
            for (SemanticElement semanticElement : set2) {
                double d3 = 0.0;
                for (InferedElement inferedElement : set) {
                    double d4 = SimilarityUtil.measureSemanticSimilarity(inferedElement.getInferedSemanticConcepts(), semanticElement.getSemanticConcepts());
                    if (d4 == 0.0) continue;
                    hashMap.put(inferedElement, Math.max((Double)hashMap.get(inferedElement), d4));
                    d3 = Math.max(d4, d3);
                }
                if (d3 != 0.0) continue;
                bl = true;
            }
            double d5 = VectorUtil.average(hashMap.values().toArray(new Double[hashMap.size()]));
            if (d5 == 0.0) {
                return 0.0;
            }
            if (bl) {
                return d5 * d;
            }
            if (hashMap.containsValue(0.0)) {
                return d5 * d2;
            }
            return d5;
        }
        return 0.0;
    }
}

