/**
 * EasierSBS project - Java file
 * Copyright (C) 2011 EBM WebSourcing - Petals Link
 * 
 * EasySWS is free project: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * EasySWS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this program.
 * If not, see <http://www.gnu.org/licenses/lgpl-3.0.txt>.	
 * 
 */ 
package com.petalslink.easiersbs.matching.service.profile.inferred;

import java.util.HashSet;
import java.util.Set;

import com.petalslink.easiersbs.matching.service.api.profile.SearchPart;
import com.petalslink.easiersbs.matching.service.api.profile.inferred.InferredConcept;
import com.petalslink.easiersbs.matching.service.api.profile.inferred.InferredPart;
import com.petalslink.easiersbs.registry.service.impl.model.generic.GenericPartImpl;


/**
 * @author Nicolas Boissel-Dallier - Petals Link
 */
public class InferredPartImpl extends GenericPartImpl implements InferredPart {
	
	Set<InferredConcept> inferedConcepts = new HashSet<InferredConcept>();
	
	public InferredPartImpl(){
		
	}
	
	public InferredPartImpl(SearchPart part){
		this.name = part.getName();
		this.concepts = part.getSemanticConcepts();
	}
	
	@Override
	public void addInferedSemanticConcept(InferredConcept semanticConcept) {
		inferedConcepts.add(semanticConcept);
	}

	@Override
	public Set<InferredConcept> getInferedSemanticConcepts() {
		return inferedConcepts;
	}

	@Override
	public void removeInferedSemanticConcept(InferredConcept semanticConcept) {
		inferedConcepts.remove(semanticConcept);
	}
	
	@Override
	public String toString(){
		return inferedConcepts.toString();
	}
	
}