/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiersbs.matching.service.matcher;

import com.petalslink.easiersbs.matching.service.SBSFactoryImpl;
import com.petalslink.easiersbs.matching.service.api.EasierSBSException;
import com.petalslink.easiersbs.matching.service.api.SBSFactory;
import com.petalslink.easiersbs.matching.service.api.matcher.HybridMatcher;
import com.petalslink.easiersbs.matching.service.api.matcher.MatcherProperties;
import com.petalslink.easiersbs.matching.service.api.matcher.MatchingResult;
import com.petalslink.easiersbs.matching.service.api.matcher.SemanticMatcher;
import com.petalslink.easiersbs.matching.service.api.matcher.SyntacticMatcher;
import com.petalslink.easiersbs.matching.service.api.profile.SearchProfile;
import com.petalslink.easiersbs.matching.service.api.profile.rated.RatedSemanticProfile;
import com.petalslink.easiersbs.matching.service.matcher.AbstractMatcherImpl;
import com.petalslink.easiersbs.matching.service.matcher.MatcherPropertiesImpl;
import com.petalslink.easiersbs.matching.service.matcher.MatchingResultImpl;
import com.petalslink.easiersbs.matching.service.profile.rated.RatedSemanticProfileImpl;
import com.petalslink.easiersbs.matching.service.util.ProfileUtil;
import com.petalslink.easiersbs.reasoner.api.ReasonerException;
import com.petalslink.easiersbs.reasoner.api.ReasonerFactory;
import com.petalslink.easiersbs.registry.service.api.SemanticRegistryManager;
import com.petalslink.easiersbs.registry.service.api.model.SemanticProfile;
import java.util.Set;

public class HybridMatcherImpl
extends AbstractMatcherImpl
implements HybridMatcher {
    private SBSFactory factory = SBSFactoryImpl.getInstance();
    private SemanticMatcher semanticMatcher;
    private SyntacticMatcher syntacticMatcher;
    private MatcherProperties props;

    public HybridMatcherImpl(ReasonerFactory reasoner, SemanticRegistryManager registry, MatcherProperties props) throws ReasonerException, EasierSBSException {
        this.props = props;
        this.registry = registry;
        this.semanticMatcher = this.factory.newSemanticMatcher(reasoner, registry, props);
        this.syntacticMatcher = this.factory.newSyntacticMatcher(registry, props);
    }

    public HybridMatcherImpl(ReasonerFactory reasoner, SemanticRegistryManager registry) throws ReasonerException, EasierSBSException {
        this(reasoner, registry, new MatcherPropertiesImpl());
    }

    @Override
    public void setMatcherProperties(MatcherProperties props) {
        this.props = props;
        this.semanticMatcher.setMatcherProperties(props);
        this.syntacticMatcher.setMatcherProperties(props);
    }

    public SyntacticMatcher getSyntacticMatcher() {
        return this.syntacticMatcher;
    }

    public SemanticMatcher getSemanticMatcher() {
        return this.semanticMatcher;
    }

    @Override
    public MatchingResult findServices(SearchProfile profile, Set<SemanticProfile> serviceList) {
        MatchingResult hybridRes = null;
        if (this.props.getSemanticWeight() == 0.0) {
            hybridRes = this.syntacticMatcher.findServices(profile, serviceList);
        } else if (this.props.getSyntacticWeigth() == 0.0) {
            hybridRes = this.semanticMatcher.findServices(profile, serviceList);
        } else {
            hybridRes = new MatchingResultImpl(profile);
            MatchingResult semanticRes = this.semanticMatcher.findServices(profile, serviceList);
            MatchingResult syntacticRes = this.syntacticMatcher.findServices(profile, ProfileUtil.getSemanticProfiles(semanticRes.getResultProfiles()));
            for (RatedSemanticProfile synProfile : syntacticRes.getResultProfiles()) {
                RatedSemanticProfileImpl hybridProfile = new RatedSemanticProfileImpl(synProfile.getProfile());
                RatedSemanticProfile semProfile = semanticRes.findProfile(synProfile.getProfile());
                hybridProfile.setProfileRate(this.getHybridRate(semProfile.getProfileRate(), synProfile.getProfileRate()));
                hybridProfile.setOperationRate(this.getHybridRate(semProfile.getOperationRate(), synProfile.getOperationRate()));
                hybridProfile.setInputCoverage(semProfile.getInputCoverage());
                hybridProfile.setInputRate(this.getHybridRate(semProfile.getInputRate(), synProfile.getInputRate()));
                hybridProfile.setOutputCoverage(semProfile.getOutputCoverage());
                hybridProfile.setOutputRate(this.getHybridRate(semProfile.getOutputRate(), synProfile.getOutputRate()));
                hybridRes.addResultProfile((RatedSemanticProfile)hybridProfile);
            }
        }
        MatchingResultImpl res = new MatchingResultImpl(profile);
        for (RatedSemanticProfile rated : hybridRes.getResultProfiles()) {
            if (!(rated.getProfileRate() >= this.props.getHybridThreshold())) continue;
            res.addResultProfile(rated);
        }
        return res;
    }

    private double getHybridRate(double semanticRate, double syntacticRate) {
        return semanticRate * this.props.getSemanticWeight() + syntacticRate * this.props.getSyntacticWeigth();
    }
}

