/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiersbs.matching.service.matcher;

import com.petalslink.easiersbs.matching.service.api.matcher.MatcherProperties;
import com.petalslink.easiersbs.matching.service.api.matcher.similarity.SimilarityType;
import java.util.Properties;

public class MatcherPropertiesImpl
implements MatcherProperties {
    private int maxThreads = 4;
    private double operationWeight = 0.5;
    private double semanticWeight = 0.75;
    private double hybridAcceptanceThreshold = 0.4;
    private double semanticAcceptanceThreshold = 0.0;
    private double syntacticAcceptanceThreshold = 0.0;
    private double exactMark = 1.0;
    private double pluginMark = 0.9;
    private double subsumeMark = 0.5;
    private double equivalentMark = 0.9;
    private double specializationMark = 0.6;
    private double generalizationMark = 0.3;
    private int levenshteinLimit = 0;
    private SimilarityType similarityType = SimilarityType.DICE;

    public MatcherPropertiesImpl() {
    }

    public MatcherPropertiesImpl(Properties props) {
        for (Object k : props.keySet()) {
            String key = k.toString().trim();
            if ("easiersbs.max.threads".equals(key)) {
                this.setMaxThreads(Integer.parseInt(props.get(key).toString().trim()));
                continue;
            }
            if ("easiersbs.general.operation.weight".equals(key)) {
                this.setOperationWeight(Double.parseDouble(props.get(key).toString().trim()));
                continue;
            }
            if ("easiersbs.hybrid.semantic.weight".equals(key)) {
                this.setSemanticWeight(Double.parseDouble(props.get(key).toString().trim()));
                continue;
            }
            if ("easiersbs.hybrid.acceptance.threshold".equals(key)) {
                this.setHybridThreshold(Double.parseDouble(props.get(key).toString().trim()));
                continue;
            }
            if ("easiersbs.semantic.acceptance.threshold".equals(key)) {
                this.setSemanticThreshold(Double.parseDouble(props.get(key).toString().trim()));
                continue;
            }
            if ("easiersbs.syntactic.acceptance.threshold".equals(key)) {
                this.setSyntacticThreshold(Double.parseDouble(props.get(key).toString().trim()));
                continue;
            }
            if ("easiersbs.semantic.exact.mark".equals(key)) {
                this.setExactMark(Double.parseDouble(props.get(key).toString().trim()));
                continue;
            }
            if ("easiersbs.semantic.plugin.mark".equals(key)) {
                this.setPluginMark(Double.parseDouble(props.get(key).toString().trim()));
                continue;
            }
            if ("easiersbs.semantic.subsume.mark".equals(key)) {
                this.setSubsumeMark(Double.parseDouble(props.get(key).toString().trim()));
                continue;
            }
            if ("easiersbs.semantic.equivalent.concept.mark".equals(key)) {
                this.setSubsumeMark(Double.parseDouble(props.get(key).toString().trim()));
                continue;
            }
            if ("easiersbs.semantic.specialization.concept.mark".equals(key)) {
                this.setSpecializationMark(Double.parseDouble(props.get(key).toString().trim()));
                continue;
            }
            if ("easiersbs.semantic.generalization.concept.mark".equals(key)) {
                this.setGeneralizationMark(Double.parseDouble(props.get(key).toString().trim()));
                continue;
            }
            if ("easiersbs.syntactic.levenshtein.limit".equals(key)) {
                this.setLevenshteinLimit(Integer.parseInt(props.get(key).toString().trim()));
                continue;
            }
            if (!"easiersbs.syntactic.similarity.type".equals(key)) continue;
            this.setSimilarityType(SimilarityType.valueOf((String)props.get(key).toString().trim()));
        }
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public double getEquivalentMark() {
        return this.equivalentMark;
    }

    public double getExactMark() {
        return this.exactMark;
    }

    public double getGeneralizationMark() {
        return this.generalizationMark;
    }

    public double getInputOutputWeigth() {
        return 1.0 - this.operationWeight;
    }

    public int getLevenshteinLimit() {
        return this.levenshteinLimit;
    }

    public double getOperationWeight() {
        return this.operationWeight;
    }

    public double getPluginMark() {
        return this.pluginMark;
    }

    public double getHybridThreshold() {
        return this.hybridAcceptanceThreshold;
    }

    public double getSemanticAcceptanceThreshold() {
        return this.semanticAcceptanceThreshold;
    }

    public double getSemanticThreshold() {
        return this.semanticAcceptanceThreshold;
    }

    public double getSemanticWeight() {
        return this.semanticWeight;
    }

    public SimilarityType getSimilarityType() {
        return this.similarityType;
    }

    public double getSpecializationMark() {
        return this.specializationMark;
    }

    public double getSubsumeMark() {
        return this.subsumeMark;
    }

    public double getSyntacticAcceptanceThreshold() {
        return this.syntacticAcceptanceThreshold;
    }

    public double getSyntacticThreshold() {
        return this.syntacticAcceptanceThreshold;
    }

    public double getSyntacticWeigth() {
        return 1.0 - this.semanticWeight;
    }

    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads > 0 ? maxThreads : 1;
    }

    public void setEquivalentMark(double equivalentMark) {
        this.equivalentMark = equivalentMark;
    }

    public void setExactMark(double mark) {
        this.exactMark = this.norm(mark);
    }

    public void setGeneralizationMark(double generalizationMark) {
        this.generalizationMark = generalizationMark;
    }

    public void setLevenshteinLimit(int levenshteinLimit) {
        this.levenshteinLimit = levenshteinLimit;
    }

    public void setOperationWeight(double weight) {
        this.operationWeight = this.norm(weight);
    }

    public void setPluginMark(double mark) {
        this.pluginMark = this.norm(mark);
    }

    public void setHybridThreshold(double threshold) {
        this.hybridAcceptanceThreshold = threshold;
    }

    public void setSemanticAcceptanceThreshold(double semanticAcceptanceThreshold) {
        this.semanticAcceptanceThreshold = semanticAcceptanceThreshold;
    }

    public void setSemanticThreshold(double threshold) {
        this.semanticAcceptanceThreshold = this.norm(threshold);
    }

    public void setSemanticWeight(double weight) {
        this.semanticWeight = this.norm(weight);
    }

    public void setSimilarityType(SimilarityType type) {
        if (type != null) {
            this.similarityType = type;
        }
    }

    public void setSpecializationMark(double specializationMark) {
        this.specializationMark = specializationMark;
    }

    public void setSubsumeMark(double mark) {
        this.subsumeMark = this.norm(mark);
    }

    public void setSyntacticAcceptanceThreshold(double syntacticAcceptanceThreshold) {
        this.syntacticAcceptanceThreshold = syntacticAcceptanceThreshold;
    }

    public void setSyntacticThreshold(double threshold) {
        this.syntacticAcceptanceThreshold = this.norm(threshold);
    }

    private double norm(double d) {
        if (d > 1.0) {
            return 1.0;
        }
        if (d < 0.0) {
            return 0.0;
        }
        return d;
    }
}

