/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiersbs.matching.service.matcher;

import com.petalslink.easiersbs.matching.service.api.matcher.MatchingResult;
import com.petalslink.easiersbs.matching.service.api.profile.SearchProfile;
import com.petalslink.easiersbs.matching.service.api.profile.rated.RatedSemanticProfile;
import com.petalslink.easiersbs.registry.service.api.model.SemanticProfile;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;

public class MatchingResultImpl
implements MatchingResult {
    private SortedSet<RatedSemanticProfile> profiles = new TreeSet<RatedSemanticProfile>();
    private SearchProfile query;

    public MatchingResultImpl(SearchProfile query) {
        this.query = query;
    }

    public SearchProfile getQuery() {
        return this.query;
    }

    public SortedSet<RatedSemanticProfile> getResultProfiles() {
        return this.profiles;
    }

    public void addResultProfile(RatedSemanticProfile profile) {
        this.profiles.add(profile);
    }

    public void removeResultProfile(RatedSemanticProfile profile) {
        this.profiles.remove(profile);
    }

    public boolean hasExactProfile() {
        if (this.profiles.first() != null) {
            return this.profiles.first().getProfileRate() == 1.0;
        }
        return false;
    }

    public boolean hasCorrectProfile(double acceptanceThreshold) {
        return this.profiles.first() != null && this.profiles.first().getProfileRate() > acceptanceThreshold;
    }

    public SortedSet<RatedSemanticProfile> getCorrectProfiles(double acceptanceThreshold) {
        TreeSet<RatedSemanticProfile> res = new TreeSet<RatedSemanticProfile>();
        for (RatedSemanticProfile profile : this.profiles) {
            if (!(profile.getProfileRate() >= acceptanceThreshold)) continue;
            res.add(profile);
        }
        return res;
    }

    public RatedSemanticProfile getBestProfile() {
        return this.profiles.first();
    }

    public SortedSet<RatedSemanticProfile> getTopKProfiles(int k) {
        TreeSet<RatedSemanticProfile> res = new TreeSet<RatedSemanticProfile>();
        Iterator it = this.profiles.iterator();
        while (it.hasNext() && res.size() < k) {
            res.add((RatedSemanticProfile)it.next());
        }
        return res;
    }

    public RatedSemanticProfile findProfile(SemanticProfile profile) {
        for (RatedSemanticProfile rated : this.profiles) {
            if (!rated.getProfile().equals(profile)) continue;
            return rated;
        }
        return null;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("MatchingResult for " + this.query.getOperationQName());
        for (RatedSemanticProfile profile : this.profiles) {
            str.append("\n" + profile.toString());
        }
        return str.toString();
    }
}

