/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiersbs.matching.service.matcher;

import com.petalslink.easiersbs.matching.service.SBSFactoryImpl;
import com.petalslink.easiersbs.matching.service.api.EasierSBSException;
import com.petalslink.easiersbs.matching.service.api.SBSFactory;
import com.petalslink.easiersbs.matching.service.api.matcher.MatcherProperties;
import com.petalslink.easiersbs.matching.service.api.matcher.MatchingResult;
import com.petalslink.easiersbs.matching.service.api.matcher.SyntacticMatcher;
import com.petalslink.easiersbs.matching.service.api.matcher.similarity.SimilarityMeasure;
import com.petalslink.easiersbs.matching.service.api.profile.SearchElement;
import com.petalslink.easiersbs.matching.service.api.profile.SearchPart;
import com.petalslink.easiersbs.matching.service.api.profile.SearchProfile;
import com.petalslink.easiersbs.matching.service.api.profile.rated.RatedSemanticProfile;
import com.petalslink.easiersbs.matching.service.matcher.AbstractMatcherImpl;
import com.petalslink.easiersbs.matching.service.matcher.MatcherPropertiesImpl;
import com.petalslink.easiersbs.matching.service.matcher.MatchingResultImpl;
import com.petalslink.easiersbs.matching.service.matcher.computation.SyntacticComputationImpl;
import com.petalslink.easiersbs.matching.service.util.SimilarityUtil;
import com.petalslink.easiersbs.registry.service.api.SemanticRegistryManager;
import com.petalslink.easiersbs.registry.service.api.model.SemanticProfile;
import com.petalslink.easiersbs.registry.service.api.model.generic.GenericElement;
import com.petalslink.easiersbs.registry.service.impl.util.ServiceUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class SyntacticMatcherImpl
extends AbstractMatcherImpl
implements SyntacticMatcher {
    private SBSFactory factory = SBSFactoryImpl.getInstance();
    private SimilarityMeasure similarity;
    private ExecutorService exec;
    private ExecutorCompletionService<RatedSemanticProfile> compExec;

    public SyntacticMatcherImpl(SemanticRegistryManager registry, MatcherProperties props) throws EasierSBSException {
        this.registry = registry;
        this.props = props;
        this.similarity = this.factory.newSimilarityMeasure(props.getSimilarityType(), props.getLevenshteinLimit());
        this.exec = Executors.newFixedThreadPool(props.getMaxThreads());
        this.compExec = new ExecutorCompletionService(this.exec);
    }

    public SyntacticMatcherImpl(SemanticRegistryManager registry) throws EasierSBSException {
        this(registry, new MatcherPropertiesImpl());
    }

    public SimilarityMeasure getSimilarityMeasure() {
        return this.similarity;
    }

    @Override
    public MatchingResult findServices(SearchProfile profile, Set<SemanticProfile> serviceList) {
        MatchingResultImpl res = new MatchingResultImpl(profile);
        try {
            this.similarity = this.factory.newSimilarityMeasure(this.props.getSimilarityType(), this.props.getLevenshteinLimit());
        }
        catch (EasierSBSException e) {
            e.printStackTrace();
        }
        List<String> functionalWords = SimilarityUtil.extractUriRelatedWords(((SearchPart)profile.getSemanticOperation()).getSemanticConcepts());
        functionalWords.addAll(SimilarityUtil.splitInWords(((SearchPart)profile.getSemanticOperation()).getName()));
        functionalWords.addAll(SimilarityUtil.extractUriRelatedWords(((SearchPart)profile.getSemanticInterface()).getSemanticConcepts()));
        functionalWords.addAll(SimilarityUtil.splitInWords(((SearchPart)profile.getSemanticInterface()).getName()));
        List<String> inputWords = SimilarityUtil.extractElementRelatedWords(ServiceUtil.getFlattenElements((GenericElement)((SearchElement)profile.getInputSemanticElement())));
        List<String> outputWords = SimilarityUtil.extractElementRelatedWords(ServiceUtil.getFlattenElements((GenericElement)((SearchElement)profile.getOutputSemanticElement())));
        HashSet<Future<RatedSemanticProfile>> results = new HashSet<Future<RatedSemanticProfile>>();
        for (SemanticProfile service : serviceList) {
            SyntacticComputationImpl compute = new SyntacticComputationImpl(this.props, this.similarity, functionalWords, inputWords, outputWords, service);
            results.add(this.compExec.submit(compute));
        }
        boolean done = false;
        while (!done) {
            done = true;
            for (Future future : results) {
                if (future.isDone()) continue;
                done = false;
                break;
            }
            if (done) continue;
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
        }
        for (Future future : results) {
            try {
                if (!(((RatedSemanticProfile)future.get()).getProfileRate() >= this.props.getSyntacticThreshold())) continue;
                res.addResultProfile((RatedSemanticProfile)future.get());
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        return res;
    }
}

