/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiersbs.matching.service.matcher.computation;

import com.petalslink.easiersbs.matching.service.api.matcher.MatcherProperties;
import com.petalslink.easiersbs.matching.service.api.profile.inferred.InferredElement;
import com.petalslink.easiersbs.matching.service.api.profile.inferred.InferredPart;
import com.petalslink.easiersbs.matching.service.api.profile.inferred.InferredProfile;
import com.petalslink.easiersbs.matching.service.api.profile.rated.RatedSemanticElement;
import com.petalslink.easiersbs.matching.service.api.profile.rated.RatedSemanticProfile;
import com.petalslink.easiersbs.matching.service.profile.rated.RatedSemanticProfileImpl;
import com.petalslink.easiersbs.matching.service.util.SimilarityUtil;
import com.petalslink.easiersbs.registry.service.api.model.SemanticElement;
import com.petalslink.easiersbs.registry.service.api.model.SemanticPart;
import com.petalslink.easiersbs.registry.service.api.model.SemanticProfile;
import java.util.concurrent.Callable;

public class SemanticComputationImpl
implements Callable<RatedSemanticProfile> {
    private MatcherProperties props;
    private InferredProfile infProfile;
    private SemanticProfile service;

    public SemanticComputationImpl(MatcherProperties props, InferredProfile infProfile, SemanticProfile targetService) {
        this.props = props;
        this.infProfile = infProfile;
        this.service = targetService;
    }

    @Override
    public RatedSemanticProfile call() throws Exception {
        RatedSemanticProfileImpl res = new RatedSemanticProfileImpl(this.service);
        if (this.props.getOperationWeight() != 0.0) {
            double interRate = SimilarityUtil.measureSemanticSimilarity(((InferredPart)this.infProfile.getSemanticInterface()).getInferedSemanticConcepts(), ((SemanticPart)this.service.getSemanticInterface()).getSemanticConcepts());
            double opRate = SimilarityUtil.measureSemanticSimilarity(((InferredPart)this.infProfile.getSemanticOperation()).getInferedSemanticConcepts(), ((SemanticPart)this.service.getSemanticOperation()).getSemanticConcepts());
            res.setOperationRate((interRate + opRate) / 2.0);
        }
        double ioRate = 0.0;
        if (this.props.getInputOutputWeigth() != 0.0) {
            RatedSemanticElement in = SimilarityUtil.measureElementSimilarity((InferredElement)this.infProfile.getInputSemanticElement(), (SemanticElement)this.service.getInputSemanticElement(), this.props.getPluginMark(), this.props.getSubsumeMark());
            res.setInputRate(in.getRate());
            res.setInputCoverage(in.getCoverage());
            if (this.infProfile.getOutputSemanticElement() != null) {
                RatedSemanticElement out = SimilarityUtil.measureElementSimilarity((InferredElement)this.infProfile.getOutputSemanticElement(), (SemanticElement)this.service.getOutputSemanticElement(), this.props.getSubsumeMark(), this.props.getPluginMark());
                res.setOutputRate(out.getRate());
                res.setOutputCoverage(out.getCoverage());
                ioRate = (res.getInputRate() + res.getOutputRate()) / 2.0;
            } else {
                ioRate = res.getInputRate();
            }
        }
        res.setProfileRate(res.getOperationRate() * this.props.getOperationWeight() + ioRate * this.props.getInputOutputWeigth());
        return res;
    }
}

