/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiersbs.matching.service.matcher.similarity;

import com.petalslink.easiersbs.matching.service.matcher.similarity.AbstractSimilarityMeasureImpl;
import com.petalslink.easiersbs.matching.service.matcher.similarity.DoubleVector;
import com.petalslink.easiersbs.matching.service.util.VectorUtil;
import java.util.List;
import java.util.Map;

public class JaccardSimilarityImpl
extends AbstractSimilarityMeasureImpl {
    public JaccardSimilarityImpl() {
    }

    public JaccardSimilarityImpl(int levenshteinLimit) {
        super.setLevenshteinLimit(levenshteinLimit);
    }

    public double measureSimilarity(List<String> words1, List<String> words2) {
        if (words1.isEmpty() || words2.isEmpty()) {
            return 0.0;
        }
        Map<String, Integer> wordFrequencies1 = this.countWordFrequency(words1);
        Map<String, Integer> wordFrequencies2 = this.countWordFrequency(words2);
        DoubleVector vectors = this.getProperVectors(wordFrequencies1, wordFrequencies2);
        double dotProduct = VectorUtil.dotProduct(vectors.getVector1(), vectors.getVector2());
        double divisor = (double)(VectorUtil.dotProduct(vectors.getVector1(), vectors.getVector1()) + VectorUtil.dotProduct(vectors.getVector2(), vectors.getVector2())) - dotProduct;
        double res = divisor == 0.0 ? 0.0 : dotProduct / divisor;
        logger.finest("Jaccard similarity fully measured: " + res);
        return res;
    }
}

