/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiersbs.matching.service.profile.rated;

import com.petalslink.easiersbs.matching.service.api.matcher.DegreeOfMatch;
import com.petalslink.easiersbs.matching.service.api.profile.rated.RatedSemanticProfile;
import com.petalslink.easiersbs.registry.service.api.model.SemanticProfile;

public class RatedSemanticProfileImpl
implements RatedSemanticProfile {
    SemanticProfile profile;
    double profileRate = 0.0;
    double operationRate = 0.0;
    double inputRate = 0.0;
    DegreeOfMatch inputCoverage = DegreeOfMatch.UNKNOWN;
    double outputRate = 0.0;
    DegreeOfMatch outputCoverage = DegreeOfMatch.UNKNOWN;

    public RatedSemanticProfileImpl(SemanticProfile profile) {
        this.profile = profile;
    }

    public RatedSemanticProfileImpl(SemanticProfile profile, double profileRate, double opRate, double inputRate, DegreeOfMatch inputCoverage, double outputRate, DegreeOfMatch outputCoverage) {
        this.profile = profile;
        this.profileRate = profileRate;
        this.operationRate = opRate;
        this.inputRate = inputRate;
        this.inputCoverage = inputCoverage;
        this.outputRate = outputRate;
        this.outputCoverage = outputCoverage;
    }

    public double getProfileRate() {
        return this.profileRate;
    }

    public void setProfileRate(double profileRate) {
        this.profileRate = profileRate;
    }

    public double getOperationRate() {
        return this.operationRate;
    }

    public void setOperationRate(double operationRate) {
        this.operationRate = operationRate;
    }

    public double getInputRate() {
        return this.inputRate;
    }

    public void setInputRate(double inputRate) {
        this.inputRate = inputRate;
    }

    public DegreeOfMatch getInputCoverage() {
        return this.inputCoverage;
    }

    public void setInputCoverage(DegreeOfMatch inputCoverage) {
        this.inputCoverage = inputCoverage;
    }

    public double getOutputRate() {
        return this.outputRate;
    }

    public void setOutputRate(double outputRate) {
        this.outputRate = outputRate;
    }

    public DegreeOfMatch getOutputCoverage() {
        return this.outputCoverage;
    }

    public void setOutputCoverage(DegreeOfMatch outputCoverage) {
        this.outputCoverage = outputCoverage;
    }

    public SemanticProfile getProfile() {
        return this.profile;
    }

    public int compareTo(RatedSemanticProfile other) {
        if (this.profileRate > other.getProfileRate()) {
            return -1;
        }
        if (this.profileRate == other.getProfileRate() && this.profile.getOperationQName().equals(other.getProfile().getOperationQName())) {
            return 0;
        }
        return 1;
    }

    public String toString() {
        String res = "Profile: " + this.profile.getOperationQName() + " - rate: " + this.profileRate;
        res = String.valueOf(res) + "\n Op: " + this.operationRate;
        res = String.valueOf(res) + " - In: " + this.inputRate + " (" + this.inputCoverage + ")";
        res = String.valueOf(res) + " - Out: " + this.outputRate + " (" + this.outputCoverage + ")";
        return res;
    }

    public int hashCode() {
        return this.profile.hashCode();
    }

    public boolean equals(Object other) {
        return this.profile.equals(other);
    }
}

