/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiersbs.matching.service.util;

import com.petalslink.easiersbs.matching.service.api.matcher.MatcherProperties;
import com.petalslink.easiersbs.matching.service.api.profile.SearchElement;
import com.petalslink.easiersbs.matching.service.api.profile.inferred.InferredConcept;
import com.petalslink.easiersbs.matching.service.api.profile.inferred.InferredElement;
import com.petalslink.easiersbs.matching.service.api.profile.inferred.RatedURI;
import com.petalslink.easiersbs.matching.service.api.profile.rated.RatedSemanticProfile;
import com.petalslink.easiersbs.matching.service.profile.SearchElementImpl;
import com.petalslink.easiersbs.matching.service.profile.inferred.InferredConceptImpl;
import com.petalslink.easiersbs.matching.service.profile.inferred.RatedURIImpl;
import com.petalslink.easiersbs.reasoner.api.engine.Reasoner;
import com.petalslink.easiersbs.registry.service.api.model.SemanticElement;
import com.petalslink.easiersbs.registry.service.api.model.SemanticProfile;
import com.petalslink.easiersbs.registry.service.api.model.generic.GenericElement;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import javax.xml.namespace.QName;

public class ProfileUtil {
    public static Set<RatedURI> getFlattenRatedUris(InferredElement element) {
        HashSet<InferredElement> listElements = new HashSet<InferredElement>();
        return ProfileUtil.getFlattenRatedUris(element, listElements);
    }

    private static Set<RatedURI> getFlattenRatedUris(InferredElement element, Set<InferredElement> listElements) {
        HashSet<RatedURI> res = new HashSet<RatedURI>();
        if (!listElements.contains(element)) {
            listElements.add(element);
            for (InferredConcept concept : element.getInferedSemanticConcepts()) {
                res.addAll(concept.getRatedSemanticConcepts());
            }
            for (InferredElement child : element.getChildElements()) {
                res.addAll(ProfileUtil.getFlattenRatedUris(child, listElements));
            }
        }
        return res;
    }

    public static SearchElement convertSemanticElement(SemanticElement element) {
        return ProfileUtil.convertSemanticElementHierarchy(element, new HashMap<QName, SearchElement>());
    }

    private static SearchElement convertSemanticElementHierarchy(SemanticElement elem, Map<QName, SearchElement> elementList) {
        SearchElementImpl res = new SearchElementImpl();
        res.setSemanticConcepts(elem.getSemanticConcepts());
        res.setElementQName(elem.getElementQName());
        res.setName(elem.getName());
        res.setRequired(elem.isRequired());
        elementList.put(elem.getElementQName(), res);
        for (SemanticElement child : elem.getChildElements()) {
            if (elementList.containsKey(child.getElementQName())) {
                res.addChildElement((GenericElement)elementList.get(child.getElementQName()));
                continue;
            }
            res.addChildElement((GenericElement)ProfileUtil.convertSemanticElementHierarchy(child, elementList));
        }
        return res;
    }

    public static InferredConcept inferConcept(URI concept, Reasoner reasoner, MatcherProperties props) {
        InferredConceptImpl inferedConcept;
        block6: {
            block5: {
                inferedConcept = new InferredConceptImpl();
                inferedConcept.addRatedSemanticConcept(new RatedURIImpl(concept, 1.0));
                if (!reasoner.isConcept(concept)) break block5;
                for (URI eqConcept : reasoner.getEquivalentClasses(concept)) {
                    if (reasoner.isThingOrNothing(eqConcept)) continue;
                    inferedConcept.addRatedSemanticConcept(new RatedURIImpl(eqConcept, props.getEquivalentMark()));
                }
                Set specConcepts = reasoner.getSubClasses(concept);
                specConcepts.addAll(reasoner.getIndividuals(concept));
                for (URI specConcept : specConcepts) {
                    if (reasoner.isThingOrNothing(specConcept)) continue;
                    inferedConcept.addRatedSemanticConcept(new RatedURIImpl(specConcept, props.getSpecializationMark()));
                }
                for (URI genConcept : reasoner.getSuperClasses(concept)) {
                    if (reasoner.isThingOrNothing(genConcept)) continue;
                    inferedConcept.addRatedSemanticConcept(new RatedURIImpl(genConcept, props.getGeneralizationMark()));
                }
                break block6;
            }
            if (!reasoner.isInstance(concept)) break block6;
            for (URI eqInstance : reasoner.getSimilarIndividuals(concept)) {
                inferedConcept.addRatedSemanticConcept(new RatedURIImpl(eqInstance, props.getEquivalentMark()));
            }
            for (URI genConcept : reasoner.getTypes(concept)) {
                if (reasoner.isThingOrNothing(genConcept)) continue;
                inferedConcept.addRatedSemanticConcept(new RatedURIImpl(genConcept, props.getGeneralizationMark()));
            }
        }
        return inferedConcept;
    }

    public static Set<SemanticProfile> getSemanticProfiles(SortedSet<RatedSemanticProfile> ratedProfiles) {
        HashSet<SemanticProfile> res = new HashSet<SemanticProfile>();
        for (RatedSemanticProfile ratedProfile : ratedProfiles) {
            res.add(ratedProfile.getProfile());
        }
        return res;
    }
}

