/**
 * EasierSBS project - Java file
 * Copyright (C) 2011 EBM WebSourcing - Petals Link
 * 
 * EasySWS is free project: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * EasySWS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this program.
 * If not, see <http://www.gnu.org/licenses/lgpl-3.0.txt>.	
 * 
 */ 
package com.petalslink.easiersbs.matching.service.profile;

import java.net.URI;
import java.util.Set;

import com.petalslink.easiersbs.matching.service.api.matcher.MatcherProperties;
import com.petalslink.easiersbs.matching.service.api.profile.SearchPart;
import com.petalslink.easiersbs.matching.service.api.profile.inferred.InferredPart;
import com.petalslink.easiersbs.matching.service.profile.inferred.InferredPartImpl;
import com.petalslink.easiersbs.matching.service.util.ProfileUtil;
import com.petalslink.easiersbs.reasoner.api.engine.Reasoner;
import com.petalslink.easiersbs.registry.service.api.model.SemanticPart;
import com.petalslink.easiersbs.registry.service.impl.model.generic.GenericPartImpl;

/**
 * @author Nicolas Boissel-Dallier - Petals Link
 */
public class SearchPartImpl extends GenericPartImpl implements SearchPart {

	
	public SearchPartImpl(){
		
	}
	
	public SearchPartImpl(String name, Set<URI> concepts){
		this.name = name;
		this.concepts = concepts;
	}
	
	public SearchPartImpl(SemanticPart part){
		this.name = part.getName();
		this.concepts = part.getSemanticConcepts();
	}
	
	@Override
	public InferredPart infer(Reasoner reasoner, MatcherProperties props) {
		InferredPart result = new InferredPartImpl();
		
		for(URI concept : this.getSemanticConcepts()){
			result.addInferedSemanticConcept(ProfileUtil.inferConcept(concept, reasoner, props));
		}
		
		return result;
	}
	
	public String toString(){
		return this.getSemanticConcepts().toString();
	}

}
