/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiersbs.matching.service.matcher.computation;

import com.petalslink.easiersbs.matching.service.api.matcher.MatcherProperties;
import com.petalslink.easiersbs.matching.service.api.profile.inferred.InferredElement;
import com.petalslink.easiersbs.matching.service.api.profile.inferred.InferredPart;
import com.petalslink.easiersbs.matching.service.api.profile.inferred.InferredProfile;
import com.petalslink.easiersbs.matching.service.api.profile.rated.RatedSemanticElement;
import com.petalslink.easiersbs.matching.service.api.profile.rated.RatedSemanticProfile;
import com.petalslink.easiersbs.matching.service.profile.rated.RatedSemanticProfileImpl;
import com.petalslink.easiersbs.matching.service.util.SimilarityUtil;
import com.petalslink.easiersbs.registry.service.api.model.SemanticElement;
import com.petalslink.easiersbs.registry.service.api.model.SemanticPart;
import com.petalslink.easiersbs.registry.service.api.model.SemanticProfile;
import java.util.concurrent.Callable;

public class SemanticComputationImpl
implements Callable<RatedSemanticProfile> {
    private MatcherProperties props;
    private InferredProfile infProfile;
    private SemanticProfile service;

    public SemanticComputationImpl(MatcherProperties matcherProperties, InferredProfile inferredProfile, SemanticProfile semanticProfile) {
        this.props = matcherProperties;
        this.infProfile = inferredProfile;
        this.service = semanticProfile;
    }

    @Override
    public RatedSemanticProfile call() throws Exception {
        double d;
        RatedSemanticProfileImpl ratedSemanticProfileImpl = new RatedSemanticProfileImpl(this.service);
        if (this.props.getOperationWeight() != 0.0) {
            d = SimilarityUtil.measureSemanticSimilarity(((InferredPart)this.infProfile.getSemanticInterface()).getInferedSemanticConcepts(), ((SemanticPart)this.service.getSemanticInterface()).getSemanticConcepts());
            double d2 = SimilarityUtil.measureSemanticSimilarity(((InferredPart)this.infProfile.getSemanticOperation()).getInferedSemanticConcepts(), ((SemanticPart)this.service.getSemanticOperation()).getSemanticConcepts());
            ratedSemanticProfileImpl.setOperationRate((d + d2) / 2.0);
        }
        d = 0.0;
        if (this.props.getInputOutputWeigth() != 0.0) {
            RatedSemanticElement ratedSemanticElement = SimilarityUtil.measureElementSimilarity((InferredElement)this.infProfile.getInputSemanticElement(), (SemanticElement)this.service.getInputSemanticElement(), this.props.getPluginMark(), this.props.getSubsumeMark());
            ratedSemanticProfileImpl.setInputRate(ratedSemanticElement.getRate());
            ratedSemanticProfileImpl.setInputCoverage(ratedSemanticElement.getCoverage());
            if (this.infProfile.getOutputSemanticElement() != null) {
                RatedSemanticElement ratedSemanticElement2 = SimilarityUtil.measureElementSimilarity((InferredElement)this.infProfile.getOutputSemanticElement(), (SemanticElement)this.service.getOutputSemanticElement(), this.props.getSubsumeMark(), this.props.getPluginMark());
                ratedSemanticProfileImpl.setOutputRate(ratedSemanticElement2.getRate());
                ratedSemanticProfileImpl.setOutputCoverage(ratedSemanticElement2.getCoverage());
                d = (ratedSemanticProfileImpl.getInputRate() + ratedSemanticProfileImpl.getOutputRate()) / 2.0;
            } else {
                d = ratedSemanticProfileImpl.getInputRate();
            }
        }
        ratedSemanticProfileImpl.setProfileRate(ratedSemanticProfileImpl.getOperationRate() * this.props.getOperationWeight() + d * this.props.getInputOutputWeigth());
        return ratedSemanticProfileImpl;
    }
}

