package com.petalslink.easiersbs.matching.service.matcher.computation;

import java.util.concurrent.Callable;

import com.petalslink.easiersbs.matching.service.api.matcher.MatcherProperties;
import com.petalslink.easiersbs.matching.service.api.profile.inferred.InferredProfile;
import com.petalslink.easiersbs.matching.service.api.profile.rated.RatedSemanticElement;
import com.petalslink.easiersbs.matching.service.api.profile.rated.RatedSemanticProfile;
import com.petalslink.easiersbs.matching.service.profile.rated.RatedSemanticProfileImpl;
import com.petalslink.easiersbs.matching.service.util.SimilarityUtil;
import com.petalslink.easiersbs.registry.service.api.model.SemanticProfile;

public class SemanticComputationImpl implements Callable<RatedSemanticProfile> {

	private MatcherProperties props;
	private InferredProfile infProfile;
	private SemanticProfile service;

	
	public SemanticComputationImpl(MatcherProperties props, InferredProfile infProfile, SemanticProfile targetService){
		this.props = props;
		this.infProfile = infProfile;
		this.service = targetService;
	}
	
	@Override
	public RatedSemanticProfile call() throws Exception {
		RatedSemanticProfile res = new RatedSemanticProfileImpl(service);
		
		
		
		if(props.getOperationWeight() != 0.0) {
			double interRate = SimilarityUtil.measureSemanticSimilarity(
					infProfile.getSemanticInterface().getInferedSemanticConcepts(), 
					service.getSemanticInterface().getSemanticConcepts());
			
			double opRate = SimilarityUtil.measureSemanticSimilarity(
					infProfile.getSemanticOperation().getInferedSemanticConcepts(),
					service.getSemanticOperation().getSemanticConcepts());
			
			res.setOperationRate(((interRate + opRate) / 2.0));
		}
		
		double ioRate = 0.0;
		if(props.getInputOutputWeigth() != 0.0) {
			RatedSemanticElement in = SimilarityUtil.measureElementSimilarity(
					infProfile.getInputSemanticElement(), 
					service.getInputSemanticElement(), 
					props.getPluginMark(), props.getSubsumeMark());
			res.setInputRate(in.getRate());
			res.setInputCoverage(in.getCoverage());
			
			// InOut service case
			if(infProfile.getOutputSemanticElement() != null) {
				RatedSemanticElement out = SimilarityUtil.measureElementSimilarity(
						infProfile.getOutputSemanticElement(),
						service.getOutputSemanticElement(), 
						props.getSubsumeMark(), props.getPluginMark());
				res.setOutputRate(out.getRate());
				res.setOutputCoverage(out.getCoverage());
				
				ioRate = ((res.getInputRate() + res.getOutputRate()) / 2.0);
				
			// InOnly service case
			} else {
				ioRate = res.getInputRate();
			}
		}
		
		res.setProfileRate(res.getOperationRate()  * props.getOperationWeight()
							+ ioRate * props.getInputOutputWeigth());
			
		return res;
	}

}
