/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiersbs.matching.service.util;

import com.petalslink.easiersbs.matching.service.api.CompositionException;
import com.petalslink.easiersbs.matching.service.api.matcher.MatcherProperties;
import com.petalslink.easiersbs.matching.service.api.profile.SearchElement;
import com.petalslink.easiersbs.matching.service.api.profile.SearchPart;
import com.petalslink.easiersbs.matching.service.api.profile.SearchProfile;
import com.petalslink.easiersbs.matching.service.api.profile.inferred.InferredConcept;
import com.petalslink.easiersbs.matching.service.api.profile.inferred.InferredElement;
import com.petalslink.easiersbs.matching.service.api.profile.inferred.RatedURI;
import com.petalslink.easiersbs.matching.service.api.profile.rated.RatedSemanticProfile;
import com.petalslink.easiersbs.matching.service.profile.SearchElementImpl;
import com.petalslink.easiersbs.matching.service.profile.SearchPartImpl;
import com.petalslink.easiersbs.matching.service.profile.SearchProfileImpl;
import com.petalslink.easiersbs.matching.service.profile.inferred.InferredConceptImpl;
import com.petalslink.easiersbs.matching.service.profile.inferred.RatedURIImpl;
import com.petalslink.easiersbs.matching.service.util.SimilarityUtil;
import com.petalslink.easiersbs.reasoner.api.engine.Reasoner;
import com.petalslink.easiersbs.registry.service.api.SemanticRegistryManager;
import com.petalslink.easiersbs.registry.service.api.model.Operation;
import com.petalslink.easiersbs.registry.service.api.model.SemanticElement;
import com.petalslink.easiersbs.registry.service.api.model.SemanticPart;
import com.petalslink.easiersbs.registry.service.api.model.SemanticProfile;
import com.petalslink.easiersbs.registry.service.api.model.generic.GenericElement;
import com.petalslink.easiersbs.registry.service.api.model.generic.GenericPart;
import com.petalslink.easiersbs.registry.service.impl.model.SemanticElementImpl;
import com.petalslink.easiersbs.registry.service.impl.model.SemanticPartImpl;
import com.petalslink.easiersbs.registry.service.impl.model.SemanticProfileImpl;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.UUID;
import javax.xml.namespace.QName;

public class ProfileUtil {
    public static Set<RatedURI> getFlattenRatedUris(InferredElement inferredElement) {
        HashSet<InferredElement> hashSet = new HashSet<InferredElement>();
        return ProfileUtil.getFlattenRatedUris(inferredElement, hashSet);
    }

    private static Set<RatedURI> getFlattenRatedUris(InferredElement inferredElement, Set<InferredElement> set) {
        HashSet<RatedURI> hashSet = new HashSet<RatedURI>();
        if (!set.contains(inferredElement)) {
            set.add(inferredElement);
            for (InferredConcept inferredConcept : inferredElement.getInferedSemanticConcepts()) {
                hashSet.addAll(inferredConcept.getRatedSemanticConcepts());
            }
            for (InferredConcept inferredConcept : inferredElement.getChildElements()) {
                hashSet.addAll(ProfileUtil.getFlattenRatedUris((InferredElement)inferredConcept, set));
            }
        }
        return hashSet;
    }

    public static SearchElement convertSemanticElement(SemanticElement semanticElement) {
        return ProfileUtil.convertSemanticElementHierarchy(semanticElement, new HashMap<QName, SearchElement>());
    }

    private static SearchElement convertSemanticElementHierarchy(SemanticElement semanticElement, Map<QName, SearchElement> map) {
        SearchElementImpl searchElementImpl = new SearchElementImpl();
        searchElementImpl.setSemanticConcepts(semanticElement.getSemanticConcepts());
        searchElementImpl.setElementQName(semanticElement.getElementQName());
        searchElementImpl.setName(semanticElement.getName());
        searchElementImpl.setRequired(semanticElement.isRequired());
        map.put(semanticElement.getElementQName(), searchElementImpl);
        for (SemanticElement semanticElement2 : semanticElement.getChildElements()) {
            if (map.containsKey(semanticElement2.getElementQName())) {
                searchElementImpl.addChildElement((GenericElement)map.get(semanticElement2.getElementQName()));
                continue;
            }
            searchElementImpl.addChildElement((GenericElement)ProfileUtil.convertSemanticElementHierarchy(semanticElement2, map));
        }
        return searchElementImpl;
    }

    public static InferredConcept inferConcept(URI uRI, Reasoner reasoner, MatcherProperties matcherProperties) {
        InferredConceptImpl inferredConceptImpl;
        block6: {
            block5: {
                Object object2;
                inferredConceptImpl = new InferredConceptImpl();
                inferredConceptImpl.addRatedSemanticConcept(new RatedURIImpl(uRI, 1.0));
                if (!reasoner.isConcept(uRI)) break block5;
                for (Object object2 : reasoner.getEquivalentClasses(uRI)) {
                    if (reasoner.isThingOrNothing((URI)object2)) continue;
                    inferredConceptImpl.addRatedSemanticConcept(new RatedURIImpl((URI)object2, matcherProperties.getEquivalentMark()));
                }
                Set set = reasoner.getSubClasses(uRI);
                set.addAll(reasoner.getIndividuals(uRI));
                object2 = set.iterator();
                while (object2.hasNext()) {
                    URI uRI2 = (URI)object2.next();
                    if (reasoner.isThingOrNothing(uRI2)) continue;
                    inferredConceptImpl.addRatedSemanticConcept(new RatedURIImpl(uRI2, matcherProperties.getSpecializationMark()));
                }
                for (URI uRI2 : reasoner.getSuperClasses(uRI)) {
                    if (reasoner.isThingOrNothing(uRI2)) continue;
                    inferredConceptImpl.addRatedSemanticConcept(new RatedURIImpl(uRI2, matcherProperties.getGeneralizationMark()));
                }
                break block6;
            }
            if (!reasoner.isInstance(uRI)) break block6;
            for (URI uRI3 : reasoner.getSimilarIndividuals(uRI)) {
                inferredConceptImpl.addRatedSemanticConcept(new RatedURIImpl(uRI3, matcherProperties.getEquivalentMark()));
            }
            for (URI uRI3 : reasoner.getTypes(uRI)) {
                if (reasoner.isThingOrNothing(uRI3)) continue;
                inferredConceptImpl.addRatedSemanticConcept(new RatedURIImpl(uRI3, matcherProperties.getGeneralizationMark()));
            }
        }
        return inferredConceptImpl;
    }

    public static Set<SemanticProfile> getSemanticProfiles(SortedSet<RatedSemanticProfile> sortedSet) {
        HashSet<SemanticProfile> hashSet = new HashSet<SemanticProfile>();
        for (RatedSemanticProfile ratedSemanticProfile : sortedSet) {
            hashSet.add(ratedSemanticProfile.getProfile());
        }
        return hashSet;
    }

    public static SemanticProfile computeEquivalentProfile(Set<Operation> set, SemanticRegistryManager semanticRegistryManager, Reasoner reasoner, MatcherProperties matcherProperties) throws CompositionException {
        SemanticProfile semanticProfile;
        HashMap<Operation, GenericElement> hashMap = new HashMap<Operation, GenericElement>();
        HashMap<Operation, GenericElement> hashMap2 = new HashMap<Operation, GenericElement>();
        HashMap<Operation, Set<Operation>> hashMap3 = new HashMap<Operation, Set<Operation>>();
        HashMap<QName, QName> hashMap4 = new HashMap<QName, QName>();
        SemanticProfileImpl semanticProfileImpl = new SemanticProfileImpl();
        semanticProfileImpl.setSemanticInterface((GenericPart)new SemanticPartImpl());
        semanticProfileImpl.setSemanticOperation((GenericPart)new SemanticPartImpl());
        for (Operation operation : set) {
            hashMap3.put(operation, new HashSet());
            semanticProfile = semanticRegistryManager.getSemanticProfile(operation);
            if (semanticProfile.getInputSemanticElement() != null) {
                hashMap.put(operation, semanticProfile.getInputSemanticElement());
            }
            if (semanticProfile.getOutputSemanticElement() != null) {
                hashMap2.put(operation, semanticProfile.getOutputSemanticElement());
            }
            semanticProfileImpl.addOperation(operation);
            if (semanticProfileImpl.getPartner() == null) {
                semanticProfileImpl.setPartner(semanticProfile.getPartner());
            }
            ProfileUtil.combineSemanticParts((SemanticPart)semanticProfileImpl.getSemanticInterface(), (SemanticPart)semanticProfile.getSemanticInterface());
            ProfileUtil.combineSemanticParts((SemanticPart)semanticProfileImpl.getSemanticOperation(), (SemanticPart)semanticProfile.getSemanticOperation());
        }
        for (Operation operation : set) {
            if (hashMap.get(operation) == null) continue;
            semanticProfile = ProfileUtil.convertSemanticElement((SemanticElement)hashMap.get(operation));
            InferredElement inferredElement = semanticProfile.infer(reasoner, matcherProperties);
            for (Operation operation2 : set) {
                Map<QName, QName> map;
                if (operation.equals(operation2) || hashMap2.get(operation2) == null || (map = SimilarityUtil.findElementMatchings(inferredElement, (SemanticElement)hashMap2.get(operation2))).isEmpty()) continue;
                ((Set)hashMap3.get(operation)).add(operation2);
                hashMap4.putAll(map);
            }
        }
        if (ProfileUtil.hasCycle(hashMap3)) {
            throw new CompositionException("There is a dependency loop between operations " + set.toString());
        }
        semanticProfileImpl.setInputSemanticElement(ProfileUtil.createUncoveredElement(new HashSet(hashMap.values()), hashMap4.keySet(), SemanticElementImpl.class));
        semanticProfileImpl.setOutputSemanticElement(ProfileUtil.createUncoveredElement(new HashSet(hashMap2.values()), new HashSet<QName>(hashMap4.values()), SemanticElementImpl.class));
        return semanticProfileImpl;
    }

    public static boolean hasCycle(Map<Operation, Set<Operation>> map) {
        HashSet<Operation> hashSet = new HashSet<Operation>();
        for (Map.Entry<Operation, Set<Operation>> object : map.entrySet()) {
            if (!object.getValue().isEmpty()) continue;
            hashSet.add(object.getKey());
        }
        while (!hashSet.isEmpty()) {
            Operation operation = (Operation)hashSet.iterator().next();
            hashSet.remove(operation);
            for (Map.Entry<Operation, Set<Operation>> entry : map.entrySet()) {
                if (!entry.getValue().remove(operation) || !entry.getValue().isEmpty()) continue;
                hashSet.add(entry.getKey());
            }
        }
        for (Set set : map.values()) {
            if (set.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static SearchProfile computeComplementaryProfile(SearchProfile searchProfile, SemanticProfile semanticProfile, Reasoner reasoner, MatcherProperties matcherProperties) {
        SearchProfileImpl searchProfileImpl = new SearchProfileImpl();
        for (Operation operation : semanticProfile.getOperations()) {
            searchProfileImpl.addOperation(operation);
        }
        searchProfileImpl.setSemanticInterface((GenericPart)ProfileUtil.substractPart((SearchPart)searchProfile.getSemanticInterface(), (SemanticPart)semanticProfile.getSemanticInterface()));
        searchProfileImpl.setSemanticOperation((GenericPart)ProfileUtil.substractPart((SearchPart)searchProfile.getSemanticOperation(), (SemanticPart)semanticProfile.getSemanticOperation()));
        searchProfileImpl.setInputSemanticElement((GenericElement)ProfileUtil.substractElement((SearchElement)searchProfile.getInputSemanticElement(), (SemanticElement)semanticProfile.getInputSemanticElement(), reasoner, matcherProperties));
        searchProfileImpl.setOutputSemanticElement((GenericElement)ProfileUtil.substractElement((SearchElement)searchProfile.getOutputSemanticElement(), (SemanticElement)semanticProfile.getOutputSemanticElement(), reasoner, matcherProperties));
        return searchProfileImpl;
    }

    private static SearchPart substractPart(SearchPart searchPart, SemanticPart semanticPart) {
        if (searchPart != null) {
            SearchPartImpl searchPartImpl = new SearchPartImpl();
            searchPartImpl.setName(searchPart.getName());
            for (URI uRI : searchPart.getSemanticConcepts()) {
                if (semanticPart != null) {
                    if (semanticPart.getSemanticConcepts().contains(uRI)) continue;
                    searchPartImpl.addSemanticConcept(uRI);
                    continue;
                }
                searchPartImpl.addSemanticConcept(uRI);
            }
            return searchPartImpl;
        }
        return null;
    }

    private static SearchElement substractElement(SearchElement searchElement, SemanticElement semanticElement, Reasoner reasoner, MatcherProperties matcherProperties) {
        if (searchElement != null) {
            if (semanticElement == null) {
                return searchElement;
            }
            InferredElement inferredElement = searchElement.infer(reasoner, matcherProperties);
            Map<QName, QName> map = SimilarityUtil.findElementMatchings(inferredElement, semanticElement);
            return ProfileUtil.createUncoveredElement(searchElement, map.keySet(), new HashSet(), SearchElementImpl.class);
        }
        return null;
    }

    private static void combineSemanticParts(SemanticPart semanticPart, SemanticPart semanticPart2) {
        if (semanticPart2 != null) {
            semanticPart.setName(semanticPart.getName() + "-" + semanticPart2.getName());
            for (URI uRI : semanticPart2.getSemanticConcepts()) {
                semanticPart.addSemanticConcept(uRI);
            }
        }
    }

    private static <E extends GenericElement<E>, EImpl extends E> E createUncoveredElement(Set<E> set, Set<QName> set2, Class<EImpl> clazz) {
        HashSet<GenericElement> hashSet = new HashSet<GenericElement>();
        for (Object object : set) {
            GenericElement genericElement3;
            GenericElement genericElement2 = ProfileUtil.createUncoveredElement(object, set2, genericElement3 = new HashSet(), clazz);
            if (genericElement2 == null) continue;
            hashSet.add(genericElement2);
        }
        if (hashSet.isEmpty()) {
            return null;
        }
        if (hashSet.size() == 1) {
            return (E)((GenericElement)hashSet.iterator().next());
        }
        GenericElement genericElement = null;
        try {
            genericElement = (GenericElement)clazz.getConstructors()[0].newInstance(new Object[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        genericElement.setElementQName(new QName("generated", UUID.randomUUID().toString()));
        genericElement.setName("generatedElement");
        for (GenericElement genericElement3 : hashSet) {
            genericElement.addChildElement(genericElement3);
        }
        return (E)genericElement;
    }

    private static <E extends GenericElement<E>, EImpl extends E> E createUncoveredElement(E e, Set<QName> set, Set<E> set2, Class<EImpl> clazz) {
        if (!e.isRequired() || set.contains(e.getElementQName())) {
            return null;
        }
        E e2 = ProfileUtil.cloneElementWithoutHierarchy(e, clazz);
        if (e.hasChildElement() && !set2.contains(e)) {
            set2.add(e);
            HashSet<GenericElement> hashSet = new HashSet<GenericElement>();
            for (GenericElement genericElement : e.getChildElements()) {
                GenericElement genericElement2 = ProfileUtil.createUncoveredElement(genericElement, set, set2, clazz);
                if (genericElement2 == null) continue;
                hashSet.add(genericElement2);
            }
            if (hashSet.isEmpty()) {
                return null;
            }
            for (GenericElement genericElement : hashSet) {
                e2.addChildElement(genericElement);
            }
        }
        return e2;
    }

    private static <E extends GenericElement<E>, EImpl extends E> E cloneElementWithoutHierarchy(E e, Class<EImpl> clazz) {
        GenericElement genericElement = null;
        try {
            genericElement = (GenericElement)clazz.getConstructors()[0].newInstance(new Object[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        genericElement.setName(e.getName());
        genericElement.setElementQName(e.getElementQName());
        for (URI uRI : e.getSemanticConcepts()) {
            genericElement.addSemanticConcept(uRI);
        }
        return (E)genericElement;
    }
}

