/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiersbs.matching.service.matcher;

import com.petalslink.easiersbs.matching.service.api.matcher.MatcherProperties;
import com.petalslink.easiersbs.matching.service.api.matcher.similarity.SimilarityType;
import java.util.Properties;

public class MatcherPropertiesImpl
implements MatcherProperties {
    private int maxThreads = 4;
    private double operationWeight = 0.5;
    private double validationRate = 0.75;
    private double semanticWeight = 0.75;
    private double hybridAcceptanceThreshold = 0.2;
    private double semanticAcceptanceThreshold = 0.0;
    private double syntacticAcceptanceThreshold = 0.0;
    private double exactMark = 1.0;
    private double pluginMark = 0.9;
    private double subsumeMark = 0.5;
    private double equivalentMark = 0.9;
    private double specializationMark = 0.6;
    private double generalizationMark = 0.3;
    private int levenshteinLimit = 0;
    private SimilarityType similarityType = SimilarityType.DICE;
    private int serviceLimit = 1;
    private int activityLimit = 1;

    public MatcherPropertiesImpl() {
    }

    public MatcherPropertiesImpl(Properties properties) {
        for (Object object : properties.keySet()) {
            String string = object.toString().trim();
            if ("easiersbs.max.threads".equals(string)) {
                this.setMaxThreads(Integer.parseInt(properties.get(string).toString().trim()));
                continue;
            }
            if ("easiersbs.general.operation.weight".equals(string)) {
                this.setOperationWeight(Double.parseDouble(properties.get(string).toString().trim()));
                continue;
            }
            if ("easiersbs.general.validation.rate".equals(string)) {
                this.setGeneralValidationRate(Double.parseDouble(properties.getProperty(string).toString().trim()));
                continue;
            }
            if ("easiersbs.hybrid.semantic.weight".equals(string)) {
                this.setSemanticWeight(Double.parseDouble(properties.get(string).toString().trim()));
                continue;
            }
            if ("easiersbs.hybrid.acceptance.threshold".equals(string)) {
                this.setHybridThreshold(Double.parseDouble(properties.get(string).toString().trim()));
                continue;
            }
            if ("easiersbs.semantic.acceptance.threshold".equals(string)) {
                this.setSemanticThreshold(Double.parseDouble(properties.get(string).toString().trim()));
                continue;
            }
            if ("easiersbs.syntactic.acceptance.threshold".equals(string)) {
                this.setSyntacticThreshold(Double.parseDouble(properties.get(string).toString().trim()));
                continue;
            }
            if ("easiersbs.semantic.exact.mark".equals(string)) {
                this.setExactMark(Double.parseDouble(properties.get(string).toString().trim()));
                continue;
            }
            if ("easiersbs.semantic.plugin.mark".equals(string)) {
                this.setPluginMark(Double.parseDouble(properties.get(string).toString().trim()));
                continue;
            }
            if ("easiersbs.semantic.subsume.mark".equals(string)) {
                this.setSubsumeMark(Double.parseDouble(properties.get(string).toString().trim()));
                continue;
            }
            if ("easiersbs.semantic.equivalent.concept.mark".equals(string)) {
                this.setSubsumeMark(Double.parseDouble(properties.get(string).toString().trim()));
                continue;
            }
            if ("easiersbs.semantic.specialization.concept.mark".equals(string)) {
                this.setSpecializationMark(Double.parseDouble(properties.get(string).toString().trim()));
                continue;
            }
            if ("easiersbs.semantic.generalization.concept.mark".equals(string)) {
                this.setGeneralizationMark(Double.parseDouble(properties.get(string).toString().trim()));
                continue;
            }
            if ("easiersbs.syntactic.levenshtein.limit".equals(string)) {
                this.setLevenshteinLimit(Integer.parseInt(properties.get(string).toString().trim()));
                continue;
            }
            if ("easiersbs.syntactic.similarity.type".equals(string)) {
                this.setSimilarityType(SimilarityType.valueOf((String)properties.get(string).toString().trim()));
                continue;
            }
            if ("easiersbs.composition.service.limit".equals(string)) {
                this.setCompositionServiceLimit(Integer.parseInt(properties.get(string).toString().trim()));
                continue;
            }
            if (!"easiersbs.composition.activity.limit".equals(string)) continue;
            this.setCompositionActivityLimit(Integer.parseInt(properties.get(string).toString().trim()));
        }
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public int getCompositionActivityLimit() {
        return this.activityLimit;
    }

    public int getCompositionServiceLimit() {
        return this.serviceLimit;
    }

    public double getEquivalentMark() {
        return this.equivalentMark;
    }

    public double getExactMark() {
        return this.exactMark;
    }

    public double getGeneralizationMark() {
        return this.generalizationMark;
    }

    public double getInputOutputWeigth() {
        return 1.0 - this.operationWeight;
    }

    public double getGeneralValidationRate() {
        return this.validationRate;
    }

    public int getLevenshteinLimit() {
        return this.levenshteinLimit;
    }

    public double getOperationWeight() {
        return this.operationWeight;
    }

    public double getPluginMark() {
        return this.pluginMark;
    }

    public double getHybridThreshold() {
        return this.hybridAcceptanceThreshold;
    }

    public double getSemanticAcceptanceThreshold() {
        return this.semanticAcceptanceThreshold;
    }

    public double getSemanticThreshold() {
        return this.semanticAcceptanceThreshold;
    }

    public double getSemanticWeight() {
        return this.semanticWeight;
    }

    public SimilarityType getSimilarityType() {
        return this.similarityType;
    }

    public double getSpecializationMark() {
        return this.specializationMark;
    }

    public double getSubsumeMark() {
        return this.subsumeMark;
    }

    public double getSyntacticAcceptanceThreshold() {
        return this.syntacticAcceptanceThreshold;
    }

    public double getSyntacticThreshold() {
        return this.syntacticAcceptanceThreshold;
    }

    public double getSyntacticWeigth() {
        return 1.0 - this.semanticWeight;
    }

    public void setMaxThreads(int n) {
        this.maxThreads = n > 0 ? n : 1;
    }

    public void setCompositionActivityLimit(int n) {
        this.activityLimit = n > 0 ? n : 1;
    }

    public void setCompositionServiceLimit(int n) {
        this.serviceLimit = n > 0 ? n : 1;
    }

    public void setEquivalentMark(double d) {
        this.equivalentMark = this.norm(d);
    }

    public void setExactMark(double d) {
        this.exactMark = this.norm(d);
    }

    public void setGeneralizationMark(double d) {
        this.generalizationMark = d;
    }

    public void setLevenshteinLimit(int n) {
        this.levenshteinLimit = n;
    }

    public void setOperationWeight(double d) {
        this.operationWeight = this.norm(d);
    }

    public void setPluginMark(double d) {
        this.pluginMark = this.norm(d);
    }

    public void setHybridThreshold(double d) {
        this.hybridAcceptanceThreshold = this.norm(d);
    }

    public void setSemanticAcceptanceThreshold(double d) {
        this.semanticAcceptanceThreshold = this.norm(d);
    }

    public void setSemanticThreshold(double d) {
        this.semanticAcceptanceThreshold = this.norm(d);
    }

    public void setSemanticWeight(double d) {
        this.semanticWeight = this.norm(d);
    }

    public void setSimilarityType(SimilarityType similarityType) {
        if (similarityType != null) {
            this.similarityType = similarityType;
        }
    }

    public void setSpecializationMark(double d) {
        this.specializationMark = d;
    }

    public void setSubsumeMark(double d) {
        this.subsumeMark = this.norm(d);
    }

    public void setSyntacticAcceptanceThreshold(double d) {
        this.syntacticAcceptanceThreshold = this.norm(d);
    }

    public void setSyntacticThreshold(double d) {
        this.syntacticAcceptanceThreshold = this.norm(d);
    }

    private double norm(double d) {
        if (d > 1.0) {
            return 1.0;
        }
        if (d < 0.0) {
            return 0.0;
        }
        return d;
    }

    public void setGeneralValidationRate(double d) {
    }
}

