/**
 * EasierSBS project - Java file
 * Copyright (C) 2011 EBM WebSourcing - Petals Link
 * 
 * EasySWS is free project: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * EasySWS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this program.
 * If not, see <http://www.gnu.org/licenses/lgpl-3.0.txt>.	
 * 
 */ 
package com.petalslink.easiersbs.matching.service;

import com.petalslink.easiersbs.matching.service.api.EasierSBSException;
import com.petalslink.easiersbs.matching.service.api.SBSFactory;
import com.petalslink.easiersbs.matching.service.api.matcher.HybridMatcher;
import com.petalslink.easiersbs.matching.service.api.matcher.MatcherProperties;
import com.petalslink.easiersbs.matching.service.api.matcher.SemanticMatcher;
import com.petalslink.easiersbs.matching.service.api.matcher.SyntacticMatcher;
import com.petalslink.easiersbs.matching.service.api.matcher.similarity.SimilarityMeasure;
import com.petalslink.easiersbs.matching.service.api.matcher.similarity.SimilarityType;
import com.petalslink.easiersbs.matching.service.matcher.HybridMatcherImpl;
import com.petalslink.easiersbs.matching.service.matcher.SemanticMatcherImpl;
import com.petalslink.easiersbs.matching.service.matcher.SyntacticMatcherImpl;
import com.petalslink.easiersbs.matching.service.matcher.similarity.CosineSimilarityImpl;
import com.petalslink.easiersbs.matching.service.matcher.similarity.DiceSimilarityImpl;
import com.petalslink.easiersbs.matching.service.matcher.similarity.JaccardSimilarityImpl;
import com.petalslink.easiersbs.matching.service.matcher.similarity.JensenShannonSimilarityImpl;
import com.petalslink.easiersbs.reasoner.api.ReasonerException;
import com.petalslink.easiersbs.reasoner.api.ReasonerFactory;
import com.petalslink.easiersbs.registry.service.api.SemanticRegistryManager;

/**
 * @author Nicolas Boissel-Dallier - Petals Link
 */
public class SBSFactoryImpl implements SBSFactory {

	private static SBSFactory instance = new SBSFactoryImpl();
	
	private SBSFactoryImpl(){
		
	}
	
	public static SBSFactory getInstance(){
		return instance;
	}


	public HybridMatcher newHybridMatcher(ReasonerFactory reasoner, SemanticRegistryManager registry) throws ReasonerException, EasierSBSException {
		return new HybridMatcherImpl(reasoner, registry);
	}
	
	public HybridMatcher newHybridMatcher(ReasonerFactory reasoner, SemanticRegistryManager registry, MatcherProperties props) throws ReasonerException, EasierSBSException {
		return new HybridMatcherImpl(reasoner, registry, props);
	}
	
	public SyntacticMatcher newSyntacticMatcher(SemanticRegistryManager registry) throws EasierSBSException {
		return new SyntacticMatcherImpl(registry);
	}
	
	public SyntacticMatcher newSyntacticMatcher(SemanticRegistryManager registry, MatcherProperties props) throws EasierSBSException {
		return new SyntacticMatcherImpl(registry, props);
	}
	
	public SemanticMatcher newSemanticMatcher(ReasonerFactory reasoner, SemanticRegistryManager registry) throws ReasonerException {
		return new SemanticMatcherImpl(reasoner, registry);
	}
	
	public SemanticMatcher newSemanticMatcher(ReasonerFactory reasoner, SemanticRegistryManager registry, MatcherProperties props) throws ReasonerException {
		return new SemanticMatcherImpl(reasoner, registry, props);
	}
	
	public SimilarityMeasure newSimilarityMeasure(SimilarityType type) throws EasierSBSException{
		if(type == null) {
			throw new EasierSBSException("Type cannot be null!!!");
		}
		switch(type){
		case COSINE:
			return new CosineSimilarityImpl();
		case DICE:
			return new DiceSimilarityImpl();
		case JACCARD:
			return new JaccardSimilarityImpl();
		case JENSEN_SHANNON:
			return new JensenShannonSimilarityImpl();
		default:
			throw new EasierSBSException("Unknown similarity type.");
		}
	}
	
	public SimilarityMeasure newSimilarityMeasure(SimilarityType type, int levenshteinLimit) throws EasierSBSException{
		SimilarityMeasure similarity = this.newSimilarityMeasure(type);
		similarity.setLevenshteinLimit(levenshteinLimit);
		return similarity;
	}

}
