/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiersbs.matching.service.matcher;

import com.petalslink.easiersbs.matching.service.api.matcher.MatcherProperties;
import com.petalslink.easiersbs.matching.service.api.matcher.MatchingResult;
import com.petalslink.easiersbs.matching.service.api.matcher.SemanticMatcher;
import com.petalslink.easiersbs.matching.service.api.profile.SearchProfile;
import com.petalslink.easiersbs.matching.service.api.profile.inferred.InferredProfile;
import com.petalslink.easiersbs.matching.service.api.profile.rated.RatedSemanticProfile;
import com.petalslink.easiersbs.matching.service.matcher.AbstractMatcherImpl;
import com.petalslink.easiersbs.matching.service.matcher.MatcherPropertiesImpl;
import com.petalslink.easiersbs.matching.service.matcher.MatchingResultImpl;
import com.petalslink.easiersbs.matching.service.matcher.computation.SemanticComputationImpl;
import com.petalslink.easiersbs.reasoner.api.ReasonerException;
import com.petalslink.easiersbs.reasoner.api.ReasonerFactory;
import com.petalslink.easiersbs.reasoner.api.engine.Reasoner;
import com.petalslink.easiersbs.reasoner.api.ontology.OntologyManager;
import com.petalslink.easiersbs.registry.service.api.SemanticRegistryManager;
import com.petalslink.easiersbs.registry.service.api.model.SemanticProfile;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class SemanticMatcherImpl
extends AbstractMatcherImpl
implements SemanticMatcher {
    private Reasoner reasoner = null;
    private OntologyManager manager = null;
    private ExecutorService exec;
    private ExecutorCompletionService<RatedSemanticProfile> compExec;

    public SemanticMatcherImpl(ReasonerFactory reasonerFactory, SemanticRegistryManager semanticRegistryManager, MatcherProperties matcherProperties) throws ReasonerException {
        this.registry = semanticRegistryManager;
        this.props = matcherProperties;
        this.manager = reasonerFactory.getOntologyManager();
        this.reasoner = reasonerFactory.newReasoner(this.manager);
        this.exec = Executors.newFixedThreadPool(matcherProperties.getMaxThreads());
        this.compExec = new ExecutorCompletionService(this.exec);
    }

    public SemanticMatcherImpl(ReasonerFactory reasonerFactory, SemanticRegistryManager semanticRegistryManager) throws ReasonerException {
        this(reasonerFactory, semanticRegistryManager, new MatcherPropertiesImpl());
    }

    public Reasoner getReasoner() {
        return this.reasoner;
    }

    public OntologyManager getOntologyManager() {
        return this.manager;
    }

    @Override
    public MatchingResult findServices(SearchProfile searchProfile, Set<SemanticProfile> set) {
        MatchingResultImpl matchingResultImpl = new MatchingResultImpl(searchProfile);
        InferredProfile inferredProfile = searchProfile.infer(this.reasoner, this.props);
        HashSet<Future<RatedSemanticProfile>> hashSet = new HashSet<Future<RatedSemanticProfile>>();
        for (SemanticProfile object : set) {
            SemanticComputationImpl semanticComputationImpl = new SemanticComputationImpl(this.props, inferredProfile, object);
            hashSet.add(this.compExec.submit(semanticComputationImpl));
        }
        boolean bl = false;
        while (!bl) {
            bl = true;
            for (Future future : hashSet) {
                if (future.isDone()) continue;
                bl = false;
                break;
            }
            if (bl) continue;
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
        }
        for (Future future : hashSet) {
            try {
                if (!(((RatedSemanticProfile)future.get()).getProfileRate() >= this.props.getSemanticThreshold())) continue;
                matchingResultImpl.addResultProfile((RatedSemanticProfile)future.get());
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
            catch (ExecutionException executionException) {
                throw new RuntimeException(executionException);
            }
        }
        return matchingResultImpl;
    }
}

