/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * WSOUIClient.java
 *
 * Created on 10 févr. 2011, 13:04:04
 */
package org.petalslink.easiestdemo.client;

import java.awt.Color;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.tree.TreePath;

import org.ow2.petals.notifier.NotificationConsumer_NotifierEndpoint_Server;
import org.petalslink.abslayer.service.api.Endpoint;
import org.petalslink.easiestdemo.client.gui.MenuMouseRegistryTree;
import org.petalslink.easiestdemo.client.gui.NotificationServerListModel;
import org.petalslink.easiestdemo.client.gui.NotificationTableModel;
import org.petalslink.easiestdemo.client.gui.TreeRegistryCellRenderer;
import org.petalslink.easiestdemo.client.gui.TreeRegistryModel;
import org.petalslink.easiestdemo.client.gui.edit.XMLEditorKit;
import org.petalslink.easiestdemo.client.model.api.Registry;
import org.petalslink.easiestdemo.client.model.api.esb.Node;
import org.petalslink.easiestdemo.client.model.api.ws.MockBinding;
import org.petalslink.easiestdemo.client.model.api.ws.MockEndpoint;
import org.petalslink.easiestdemo.client.model.api.ws.MockOperation;
import org.petalslink.easiestdemo.client.model.api.ws.MockService;
import org.petalslink.easiestdemo.client.model.impl.RegistryImpl;
import org.petalslink.easiestdemo.client.notification.AddNotificationServerFrame;
import org.petalslink.easiestdemo.client.notification.FilterFrame;
import org.petalslink.easiestdemo.client.notification.NotificationConsumerMock;
import org.petalslink.easiestdemo.client.notification.NotifyGui;
import org.petalslink.easiestdemo.client.topology.TopologyView;

import com.ebmwebsourcing.easycommons.soap.handler.SOAPException;

/**
 *
 * @author nsalatge
 */
public class WSOUIClient extends javax.swing.JFrame {

	private static Logger LOG = Logger.getLogger(WSOUIClient.class.getName());

	public static final URL CLIENT_IMAGE = Thread.currentThread().getContextClassLoader().getResource("images/client.png");
	public static final URL CLIENT_TEL_IMAGE = Thread.currentThread().getContextClassLoader().getResource("images/client_tel.png");
	public static final URL CLIENT_HAPPY_IMAGE = Thread.currentThread().getContextClassLoader().getResource("images/client_happy.png");
	public static final URL CLIENT_SAD_IMAGE = Thread.currentThread().getContextClassLoader().getResource("images/client_sad.png");


	public static final URL ICON_IMAGE = Thread.currentThread().getContextClassLoader().getResource("images/easylink-ico.png");
	public static final URL ICON_IMAGE_LOGO = Thread.currentThread().getContextClassLoader().getResource("images/easiestdemo.png");
	public static final URL ICON_PLAY = Thread.currentThread().getContextClassLoader().getResource("images/next-bleu-arrow.png");

	private Color color = new Color(138, 246, 236);
	private JColorChooser colorChooser = new JColorChooser(this.color);

	private Registry registry = null;
	private List<NotificationConsumer_NotifierEndpoint_Server> notificationServers = new ArrayList<NotificationConsumer_NotifierEndpoint_Server>();
	private NotificationConsumer_NotifierEndpoint_Server currentNotificationServer = null;

	private TopologyView topology;

	private MenuMouseRegistryTree mmr;


	/** Creates new form WSOUIClient 
	 * @throws WSOUIException */
	public WSOUIClient() throws WSOUIClientException {
		try {
			initComponents();

			this.setTitle("EasiestDEMO WSOUI Client");
			this.setIconImage(Toolkit.getDefaultToolkit().getImage(ICON_IMAGE));

			this.mmr = new MenuMouseRegistryTree(this);
			this.registry = new RegistryImpl();

			// panel web service
			this.jLabelImage.setIcon(new ImageIcon(CLIENT_IMAGE));
			this.jLabelImageLogo.setIcon(new ImageIcon(ICON_IMAGE_LOGO));
			this.setLocation();
			this.jEditorPaneRequest.setEditorKit(new XMLEditorKit());
			this.jEditorPaneResponse.setEditorKit(new XMLEditorKit());
			this.jButtonPlay.setIcon(createImageIcon(this.jButtonPlay, ICON_PLAY));

			// panel notification server
			this.jEditorPaneNotification.setEditorKit(new XMLEditorKit());
			this.jTextFieldNotificationServer.setEditable(false);
			this.jTextFieldNumberOfNotificationReceived.setEditable(false);

			// panel topology
			this.topology = new TopologyView(this.jPanelView.getSize(), this);
			this.jPanelView.setLayout(new GridLayout(1, 1));
			this.jPanelView.add(this.topology);

			this.refreshAll();
			this.refreshListNotification();
			this.setColor();

			this.jTableNotification.setModel(new NotificationTableModel(new ArrayList<NotifyGui>()));
		} catch (SOAPException e) {
			throw new WSOUIClientException(e);
		}
	}

	public Registry getRegistry() {
		return registry;
	}

	public TopologyView getTopology() {
		return topology;
	}

	public Color getColor() {
		return color;
	}

	public void setColor(Color color) {
		this.color = color;
	}

	public void setColor() {
		this.jTabbedPane.setBackground(color);
		this.jPanelWebServiceClient.setBackground(color);
		this.jPanelNotificationEventClient.setBackground(color);
		this.jPanelRequest.setBackground(color);
		this.jPanelResponse.setBackground(color);
		this.jPanelLog.setBackground(color);
		this.jPanelProperties.setBackground(color);
	}

	public NotificationConsumer_NotifierEndpoint_Server[] getNotificationServers() {
		return notificationServers.toArray(new NotificationConsumer_NotifierEndpoint_Server[notificationServers.size()]);
	}

	public NotificationConsumer_NotifierEndpoint_Server getCurrentNotificationServer() {
		return currentNotificationServer;
	}

	private WSOUIClient getFrame() {
		return this;
	}

	public MenuMouseRegistryTree getMmr() {
		return mmr;
	}

	public void setMmr(MenuMouseRegistryTree mmr) {
		this.mmr = mmr;
	}

	public void refreshAll() throws WSOUIClientException {
		try {
			this.jTree.setModel(new TreeRegistryModel(this.registry));
			this.jTree.setCellRenderer(new TreeRegistryCellRenderer());
			this.jTree.paint(this.jTree.getGraphics());
			this.topology.refresh();
			this.printAllNotifications();
		} catch (SOAPException e) {
			throw new WSOUIClientException(e);
		}
	}

	public void refreshListNotification() {
		this.jListNotificationServer.setModel(new NotificationServerListModel(this.notificationServers));

	}


	public void addNewNotificationServers(String... servers) throws WSOUIClientException {
		try {
			if(servers != null) {
				for(String serverAddress: servers) {
					NotificationConsumerMock notifier = new NotificationConsumerMock(this);
					NotificationConsumer_NotifierEndpoint_Server notifServer;
					notifServer = new NotificationConsumer_NotifierEndpoint_Server(
							notifier, serverAddress);
					this.notificationServers.add(notifServer);
				}
				this.refreshListNotification();
			}
		} catch (Exception e) {
			throw new WSOUIClientException(e);
		}
	}



	public Node addNewAdminWsdlofESBNode(URL... urls) throws WSOUIClientException {
		Node n = this.registry.addNewAdminWsdlofESBNode(urls);
		this.refreshAll();
		return n;
	}

	public void addNewWsdlofWebServices(URL... urls) throws WSOUIClientException {
		this.registry.addNewWsdlofWebServices(urls);
		this.refreshAll();
	}

	public javax.swing.JTextField getjTextFieldEndpointName() {
		return jTextFieldEndpointName;
	}


	public javax.swing.JLabel getjLabelImage() {
		return jLabelImage;
	}

	public void setjLabelImage(javax.swing.JLabel jLabelImage) {
		this.jLabelImage = jLabelImage;
	}

	public void setjTextFieldEndpointName(
			javax.swing.JTextField jTextFieldEndpointName) {
		this.jTextFieldEndpointName = jTextFieldEndpointName;
	}

	public javax.swing.JTextField getjTextFieldInterfaceQName() {
		return jTextFieldInterfaceQName;
	}

	public void setjTextFieldInterfaceQName(
			javax.swing.JTextField jTextFieldInterfaceQName) {
		this.jTextFieldInterfaceQName = jTextFieldInterfaceQName;
	}

	public javax.swing.JEditorPane getjEditorPaneResponse() {
		return jEditorPaneResponse;
	}

	public void setjEditorPaneResponse(javax.swing.JEditorPane jEditorPaneResponse) {
		this.jEditorPaneResponse = jEditorPaneResponse;
	}

	public javax.swing.JTextField getjTextFieldOperationName() {
		return jTextFieldOperationName;
	}

	public void setjTextFieldOperationName(
			javax.swing.JTextField jTextFieldOperationName) {
		this.jTextFieldOperationName = jTextFieldOperationName;
	}

	public javax.swing.JTextField getjTextFieldNumberOfNotificationReceived() {
		return jTextFieldNumberOfNotificationReceived;
	}

	public javax.swing.JEditorPane getjEditorPaneRequest() {
		return jEditorPaneRequest;
	}

	public void setjEditorPaneRequest(javax.swing.JEditorPane jEditorPaneRequest) {
		this.jEditorPaneRequest = jEditorPaneRequest;
	}

	public javax.swing.JTextField getjTextFieldSendTo() {
		return jTextFieldSendTo;
	}

	public void setjTextFieldSendTo(javax.swing.JTextField jTextFieldSendTo) {
		this.jTextFieldSendTo = jTextFieldSendTo;
	}

	public javax.swing.JTextField getjTextFieldServiceQName() {
		return jTextFieldServiceQName;
	}

	public void setjTextFieldServiceQName(
			javax.swing.JTextField jTextFieldServiceQName) {
		this.jTextFieldServiceQName = jTextFieldServiceQName;
	}

	private ImageIcon createImageIcon(JButton button, URL url) {
		ImageIcon icon = new ImageIcon(url);
		Image img = icon.getImage() ;
		Image newImg = img.getScaledInstance(button.getWidth(), button.getHeight(), java.awt.Image.SCALE_SMOOTH);
		icon = new ImageIcon(newImg);
		return icon;
	}

	public javax.swing.JTable getjTableNotification() {
		return jTableNotification;
	}

	private void setLocation() {
		double heightScreen = Toolkit.getDefaultToolkit().getScreenSize().getHeight();
		double witdhScreen = Toolkit.getDefaultToolkit().getScreenSize().getWidth();
		this.setLocation((int)witdhScreen/2 - this.getWidth()/2, (int)heightScreen/2 - this.getHeight()/2);
	}

	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
	@SuppressWarnings("unchecked")
	// <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
	private void initComponents() {

		jTabbedPane = new javax.swing.JTabbedPane();
		jPanelWebServiceClient = new javax.swing.JPanel();
		jScrollPaneTree = new javax.swing.JScrollPane();
		jTree = new javax.swing.JTree();
		jLabelImage = new javax.swing.JLabel();
		jPanelRequest = new javax.swing.JPanel();
		jScrollPaneRequest = new javax.swing.JScrollPane();
		jEditorPaneRequest = new javax.swing.JEditorPane();
		jButtonPlay = new javax.swing.JButton();
		jPanelResponse = new javax.swing.JPanel();
		jScrollPaneResponse = new javax.swing.JScrollPane();
		jEditorPaneResponse = new javax.swing.JEditorPane();
		jLabelSendTo = new javax.swing.JLabel();
		jTextFieldSendTo = new javax.swing.JTextField();
		jLabelServiceQName = new javax.swing.JLabel();
		jLabelInterfaceQName = new javax.swing.JLabel();
		jTextFieldServiceQName = new javax.swing.JTextField();
		jTextFieldInterfaceQName = new javax.swing.JTextField();
		jLabelEndpointName = new javax.swing.JLabel();
		jTextFieldEndpointName = new javax.swing.JTextField();
		jLabelOperationName = new javax.swing.JLabel();
		jTextFieldOperationName = new javax.swing.JTextField();
		jLabelImageLogo = new javax.swing.JLabel();
		jPanelNotificationEventClient = new javax.swing.JPanel();
		jLabelNotificationServerAddress = new javax.swing.JLabel();
		jScrollPane = new javax.swing.JScrollPane();
		jListNotificationServer = new javax.swing.JList();
		jButtonAddNotificationServer = new javax.swing.JButton();
		jScrollPaneNotificationTable = new javax.swing.JScrollPane();
		jTableNotification = new javax.swing.JTable();
		jScrollPaneNotificationEditor = new javax.swing.JScrollPane();
		jEditorPaneNotification = new javax.swing.JEditorPane();
		jPanelAllNotification = new javax.swing.JPanel();
		jLabelTotalNumberName = new javax.swing.JLabel();
		jLabelTotalNumberValue = new javax.swing.JLabel();
		jLabelNotificationServerSelected = new javax.swing.JLabel();
		jTextFieldNotificationServer = new javax.swing.JTextField();
		jLabelNotificationNumberOfServer = new javax.swing.JLabel();
		jTextFieldNumberOfNotificationReceived = new javax.swing.JTextField();
		jButtonFilter = new javax.swing.JButton();
		jPanelTopology = new javax.swing.JPanel();
		jSplitPaneTopology = new javax.swing.JSplitPane();
		jPanelView = new javax.swing.JPanel();
		jTabbedPaneAll = new javax.swing.JTabbedPane();
		jPanelLog = new javax.swing.JPanel();
		jScrollPaneLog = new javax.swing.JScrollPane();
		jTextAreaLog = new javax.swing.JTextArea();
		jPanelProperties = new javax.swing.JPanel();
		jScrollPaneProperties = new javax.swing.JScrollPane();
		jTableProperties = new javax.swing.JTable();
		jMenuBar = new javax.swing.JMenuBar();
		jMenuFile = new javax.swing.JMenu();
		jMenuItemAddWSDL = new javax.swing.JMenuItem();
		jMenuItemExit = new javax.swing.JMenuItem();
		jMenuEdit = new javax.swing.JMenu();
		jMenuItemChangeColor = new javax.swing.JMenuItem();
		jMenuItemRefresh = new javax.swing.JMenuItem();

		setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);

		jTabbedPane.addMouseListener(new java.awt.event.MouseAdapter() {
			public void mouseClicked(java.awt.event.MouseEvent evt) {
				jTabbedPaneMouseClicked(evt);
			}
		});

		jTree.addMouseListener(new java.awt.event.MouseAdapter() {
			public void mouseClicked(java.awt.event.MouseEvent evt) {
				jTreeMouseClicked(evt);
			}
		});
		jScrollPaneTree.setViewportView(jTree);

		jLabelImage.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);

		jPanelRequest.setBorder(javax.swing.BorderFactory.createTitledBorder("Request:"));

		jScrollPaneRequest.setViewportView(jEditorPaneRequest);

		javax.swing.GroupLayout jPanelRequestLayout = new javax.swing.GroupLayout(jPanelRequest);
		jPanelRequest.setLayout(jPanelRequestLayout);
		jPanelRequestLayout.setHorizontalGroup(
				jPanelRequestLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
				.addGroup(jPanelRequestLayout.createSequentialGroup()
						.addContainerGap()
						.addComponent(jScrollPaneRequest, javax.swing.GroupLayout.DEFAULT_SIZE, 363, Short.MAX_VALUE)
						.addContainerGap())
		);
		jPanelRequestLayout.setVerticalGroup(
				jPanelRequestLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
				.addGroup(jPanelRequestLayout.createSequentialGroup()
						.addComponent(jScrollPaneRequest, javax.swing.GroupLayout.DEFAULT_SIZE, 403, Short.MAX_VALUE)
						.addContainerGap())
		);

		jButtonPlay.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				jButtonPlayActionPerformed(evt);
			}
		});

		jPanelResponse.setBorder(javax.swing.BorderFactory.createTitledBorder("Response:"));

		jScrollPaneResponse.setViewportView(jEditorPaneResponse);

		javax.swing.GroupLayout jPanelResponseLayout = new javax.swing.GroupLayout(jPanelResponse);
		jPanelResponse.setLayout(jPanelResponseLayout);
		jPanelResponseLayout.setHorizontalGroup(
				jPanelResponseLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
				.addGroup(jPanelResponseLayout.createSequentialGroup()
						.addContainerGap()
						.addComponent(jScrollPaneResponse, javax.swing.GroupLayout.DEFAULT_SIZE, 310, Short.MAX_VALUE)
						.addContainerGap())
		);
		jPanelResponseLayout.setVerticalGroup(
				jPanelResponseLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
				.addGroup(jPanelResponseLayout.createSequentialGroup()
						.addComponent(jScrollPaneResponse, javax.swing.GroupLayout.DEFAULT_SIZE, 403, Short.MAX_VALUE)
						.addContainerGap())
		);

		jLabelSendTo.setText("Send to:");

		jLabelServiceQName.setText("Service QName:");

		jLabelInterfaceQName.setText("Interface QName:");

		jTextFieldServiceQName.setEditable(false);

		jTextFieldInterfaceQName.setEditable(false);

		jLabelEndpointName.setText("Endpoint Name:");

		jTextFieldEndpointName.setEditable(false);

		jLabelOperationName.setText("Operation Name:");

		jTextFieldOperationName.setEditable(false);

		jLabelImageLogo.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);

		javax.swing.GroupLayout jPanelWebServiceClientLayout = new javax.swing.GroupLayout(jPanelWebServiceClient);
		jPanelWebServiceClient.setLayout(jPanelWebServiceClientLayout);
		jPanelWebServiceClientLayout.setHorizontalGroup(
				jPanelWebServiceClientLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
				.addGroup(jPanelWebServiceClientLayout.createSequentialGroup()
						.addContainerGap()
						.addGroup(jPanelWebServiceClientLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
								.addComponent(jScrollPaneTree, javax.swing.GroupLayout.DEFAULT_SIZE, 280, Short.MAX_VALUE)
								.addComponent(jLabelImage, javax.swing.GroupLayout.DEFAULT_SIZE, 280, Short.MAX_VALUE))
								.addGroup(jPanelWebServiceClientLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
										.addGroup(jPanelWebServiceClientLayout.createSequentialGroup()
												.addGap(6, 6, 6)
												.addComponent(jPanelRequest, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
												.addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
												.addComponent(jButtonPlay, javax.swing.GroupLayout.PREFERRED_SIZE, 94, javax.swing.GroupLayout.PREFERRED_SIZE)
												.addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
												.addComponent(jPanelResponse, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
												.addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanelWebServiceClientLayout.createSequentialGroup()
														.addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
														.addComponent(jLabelSendTo)
														.addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
														.addComponent(jTextFieldSendTo, javax.swing.GroupLayout.PREFERRED_SIZE, 511, javax.swing.GroupLayout.PREFERRED_SIZE))
														.addGroup(jPanelWebServiceClientLayout.createSequentialGroup()
																.addGap(18, 18, 18)
																.addGroup(jPanelWebServiceClientLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
																		.addGroup(jPanelWebServiceClientLayout.createSequentialGroup()
																				.addComponent(jLabelServiceQName, javax.swing.GroupLayout.DEFAULT_SIZE, 238, Short.MAX_VALUE)
																				.addGap(344, 344, 344))
																				.addGroup(jPanelWebServiceClientLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
																						.addGroup(javax.swing.GroupLayout.Alignment.LEADING, jPanelWebServiceClientLayout.createSequentialGroup()
																								.addGroup(jPanelWebServiceClientLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
																										.addComponent(jLabelEndpointName)
																										.addComponent(jLabelOperationName))
																										.addGap(18, 18, 18)
																										.addGroup(jPanelWebServiceClientLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
																												.addComponent(jTextFieldOperationName, javax.swing.GroupLayout.DEFAULT_SIZE, 340, Short.MAX_VALUE)
																												.addComponent(jTextFieldEndpointName)))
																												.addGroup(javax.swing.GroupLayout.Alignment.LEADING, jPanelWebServiceClientLayout.createSequentialGroup()
																														.addComponent(jLabelInterfaceQName)
																														.addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
																														.addGroup(jPanelWebServiceClientLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
																																.addComponent(jTextFieldServiceQName)
																																.addComponent(jTextFieldInterfaceQName, javax.swing.GroupLayout.DEFAULT_SIZE, 343, Short.MAX_VALUE)))))
																																.addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
																																.addComponent(jLabelImageLogo, javax.swing.GroupLayout.DEFAULT_SIZE, 257, Short.MAX_VALUE)))
																																.addContainerGap())
		);
		jPanelWebServiceClientLayout.setVerticalGroup(
				jPanelWebServiceClientLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
				.addGroup(jPanelWebServiceClientLayout.createSequentialGroup()
						.addGroup(jPanelWebServiceClientLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
								.addGroup(jPanelWebServiceClientLayout.createSequentialGroup()
										.addGap(38, 38, 38)
										.addGroup(jPanelWebServiceClientLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
												.addComponent(jLabelInterfaceQName)
												.addComponent(jTextFieldInterfaceQName, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
												.addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
												.addGroup(jPanelWebServiceClientLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
														.addComponent(jLabelEndpointName)
														.addComponent(jTextFieldEndpointName, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
														.addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
														.addGroup(jPanelWebServiceClientLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
																.addComponent(jLabelOperationName)
																.addComponent(jTextFieldOperationName, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
																.addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
																.addGroup(jPanelWebServiceClientLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
																		.addComponent(jTextFieldSendTo, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
																		.addComponent(jLabelSendTo))
																		.addGap(142, 142, 142)
																		.addComponent(jButtonPlay, javax.swing.GroupLayout.PREFERRED_SIZE, 78, javax.swing.GroupLayout.PREFERRED_SIZE))
																		.addGroup(jPanelWebServiceClientLayout.createSequentialGroup()
																				.addContainerGap()
																				.addGroup(jPanelWebServiceClientLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
																						.addGroup(jPanelWebServiceClientLayout.createSequentialGroup()
																								.addGroup(jPanelWebServiceClientLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
																										.addComponent(jLabelImageLogo, javax.swing.GroupLayout.PREFERRED_SIZE, 95, javax.swing.GroupLayout.PREFERRED_SIZE)
																										.addGroup(jPanelWebServiceClientLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
																												.addComponent(jLabelServiceQName)
																												.addComponent(jTextFieldServiceQName, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
																												.addGap(46, 46, 46)
																												.addGroup(jPanelWebServiceClientLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
																														.addComponent(jPanelRequest, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
																														.addComponent(jPanelResponse, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
																														.addGap(21, 21, 21))
																														.addGroup(jPanelWebServiceClientLayout.createSequentialGroup()
																																.addComponent(jScrollPaneTree, javax.swing.GroupLayout.DEFAULT_SIZE, 393, Short.MAX_VALUE)
																																.addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
																																.addComponent(jLabelImage, javax.swing.GroupLayout.DEFAULT_SIZE, 207, Short.MAX_VALUE)))))
																																.addGap(0, 0, 0))
		);

		jTabbedPane.addTab("Web Service Client", jPanelWebServiceClient);

		jLabelNotificationServerAddress.setText("Notification servers address:");

		jListNotificationServer.setModel(new javax.swing.AbstractListModel() {
			String[] strings = { "Item 1", "Item 2", "Item 3", "Item 4", "Item 5" };
			public int getSize() { return strings.length; }
			public Object getElementAt(int i) { return strings[i]; }
		});
		jListNotificationServer.addMouseListener(new java.awt.event.MouseAdapter() {
			public void mouseClicked(java.awt.event.MouseEvent evt) {
				jListNotificationServerMouseClicked(evt);
			}
		});
		jScrollPane.setViewportView(jListNotificationServer);

		jButtonAddNotificationServer.setText("Add");
		jButtonAddNotificationServer.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				jButtonAddNotificationServerActionPerformed(evt);
			}
		});

		jTableNotification.setModel(new javax.swing.table.DefaultTableModel(
				new Object [][] {
						{null, null, null},
						{null, null, null},
						{null, null, null},
						{null, null, null}
				},
				new String [] {
						"Date", "From", "Notification"
				}
		) {
			Class[] types = new Class [] {
					java.lang.String.class, java.lang.String.class, java.lang.Object.class
			};

			public Class getColumnClass(int columnIndex) {
				return types [columnIndex];
			}
		});
		jTableNotification.addMouseListener(new java.awt.event.MouseAdapter() {
			public void mouseClicked(java.awt.event.MouseEvent evt) {
				jTableNotificationMouseClicked(evt);
			}
		});
		jScrollPaneNotificationTable.setViewportView(jTableNotification);

		jScrollPaneNotificationEditor.setViewportView(jEditorPaneNotification);

		jPanelAllNotification.setBorder(javax.swing.BorderFactory.createBevelBorder(javax.swing.border.BevelBorder.RAISED));

		jLabelTotalNumberName.setFont(new java.awt.Font("Tahoma", 1, 14));
		jLabelTotalNumberName.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
		jLabelTotalNumberName.setText("Total number of Notifcations :");

		jLabelTotalNumberValue.setFont(new java.awt.Font("Tahoma", 1, 48));
		jLabelTotalNumberValue.setForeground(new java.awt.Color(0, 102, 0));
		jLabelTotalNumberValue.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
		jLabelTotalNumberValue.setText("0");

		javax.swing.GroupLayout jPanelAllNotificationLayout = new javax.swing.GroupLayout(jPanelAllNotification);
		jPanelAllNotification.setLayout(jPanelAllNotificationLayout);
		jPanelAllNotificationLayout.setHorizontalGroup(
				jPanelAllNotificationLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
				.addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanelAllNotificationLayout.createSequentialGroup()
						.addContainerGap()
						.addGroup(jPanelAllNotificationLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
								.addComponent(jLabelTotalNumberValue, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 296, Short.MAX_VALUE)
								.addComponent(jLabelTotalNumberName, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 296, Short.MAX_VALUE))
								.addContainerGap())
		);
		jPanelAllNotificationLayout.setVerticalGroup(
				jPanelAllNotificationLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
				.addGroup(jPanelAllNotificationLayout.createSequentialGroup()
						.addContainerGap()
						.addComponent(jLabelTotalNumberName)
						.addGap(18, 18, 18)
						.addComponent(jLabelTotalNumberValue, javax.swing.GroupLayout.PREFERRED_SIZE, 71, javax.swing.GroupLayout.PREFERRED_SIZE)
						.addContainerGap(19, Short.MAX_VALUE))
		);

		jLabelNotificationServerSelected.setText("Notification server selected:");

		jLabelNotificationNumberOfServer.setText("Number of notification received:");

		jButtonFilter.setText("Filter");
		jButtonFilter.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				jButtonFilterActionPerformed(evt);
			}
		});

		javax.swing.GroupLayout jPanelNotificationEventClientLayout = new javax.swing.GroupLayout(jPanelNotificationEventClient);
		jPanelNotificationEventClient.setLayout(jPanelNotificationEventClientLayout);
		jPanelNotificationEventClientLayout.setHorizontalGroup(
				jPanelNotificationEventClientLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
				.addGroup(jPanelNotificationEventClientLayout.createSequentialGroup()
						.addContainerGap()
						.addGroup(jPanelNotificationEventClientLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
								.addComponent(jLabelNotificationServerAddress)
								.addComponent(jButtonAddNotificationServer)
								.addComponent(jScrollPane, javax.swing.GroupLayout.DEFAULT_SIZE, 320, Short.MAX_VALUE)
								.addComponent(jPanelAllNotification, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
								.addGap(18, 18, 18)
								.addGroup(jPanelNotificationEventClientLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
										.addComponent(jScrollPaneNotificationEditor, 0, 0, Short.MAX_VALUE)
										.addGroup(jPanelNotificationEventClientLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
												.addGroup(javax.swing.GroupLayout.Alignment.LEADING, jPanelNotificationEventClientLayout.createSequentialGroup()
														.addGroup(jPanelNotificationEventClientLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
																.addComponent(jLabelNotificationNumberOfServer)
																.addComponent(jLabelNotificationServerSelected))
																.addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
																.addGroup(jPanelNotificationEventClientLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
																		.addComponent(jTextFieldNotificationServer, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.PREFERRED_SIZE, 546, javax.swing.GroupLayout.PREFERRED_SIZE)
																		.addComponent(jTextFieldNumberOfNotificationReceived, javax.swing.GroupLayout.Alignment.LEADING)))
																		.addComponent(jScrollPaneNotificationTable, javax.swing.GroupLayout.PREFERRED_SIZE, 799, javax.swing.GroupLayout.PREFERRED_SIZE))
																		.addComponent(jButtonFilter))
																		.addContainerGap())
		);
		jPanelNotificationEventClientLayout.setVerticalGroup(
				jPanelNotificationEventClientLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
				.addGroup(jPanelNotificationEventClientLayout.createSequentialGroup()
						.addContainerGap()
						.addComponent(jLabelNotificationServerAddress)
						.addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
						.addGroup(jPanelNotificationEventClientLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
								.addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanelNotificationEventClientLayout.createSequentialGroup()
										.addGroup(jPanelNotificationEventClientLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
												.addComponent(jLabelNotificationServerSelected)
												.addComponent(jTextFieldNotificationServer, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
												.addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
												.addGroup(jPanelNotificationEventClientLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
														.addComponent(jLabelNotificationNumberOfServer)
														.addComponent(jTextFieldNumberOfNotificationReceived, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
														.addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
														.addComponent(jScrollPaneNotificationTable, javax.swing.GroupLayout.DEFAULT_SIZE, 236, Short.MAX_VALUE)
														.addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
														.addComponent(jScrollPaneNotificationEditor, javax.swing.GroupLayout.PREFERRED_SIZE, 244, javax.swing.GroupLayout.PREFERRED_SIZE)
														.addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
														.addComponent(jButtonFilter)
														.addGap(3, 3, 3))
														.addGroup(jPanelNotificationEventClientLayout.createSequentialGroup()
																.addComponent(jScrollPane, javax.swing.GroupLayout.PREFERRED_SIZE, 395, javax.swing.GroupLayout.PREFERRED_SIZE)
																.addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
																.addComponent(jButtonAddNotificationServer)
																.addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
																.addComponent(jPanelAllNotification, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)))
																.addContainerGap())
		);

		jTabbedPane.addTab("Notification Event Client", jPanelNotificationEventClient);

		jSplitPaneTopology.setDividerLocation(500);
		jSplitPaneTopology.setOrientation(javax.swing.JSplitPane.VERTICAL_SPLIT);
		jSplitPaneTopology.setLastDividerLocation(500);
		jSplitPaneTopology.setOneTouchExpandable(true);

		javax.swing.GroupLayout jPanelViewLayout = new javax.swing.GroupLayout(jPanelView);
		jPanelView.setLayout(jPanelViewLayout);
		jPanelViewLayout.setHorizontalGroup(
				jPanelViewLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
				.addGap(0, 1155, Short.MAX_VALUE)
		);
		jPanelViewLayout.setVerticalGroup(
				jPanelViewLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
				.addGap(0, 499, Short.MAX_VALUE)
		);

		jSplitPaneTopology.setTopComponent(jPanelView);

		jPanelLog.setName("Log"); // NOI18N

		jTextAreaLog.setColumns(20);
		jTextAreaLog.setRows(5);
		jScrollPaneLog.setViewportView(jTextAreaLog);

		javax.swing.GroupLayout jPanelLogLayout = new javax.swing.GroupLayout(jPanelLog);
		jPanelLog.setLayout(jPanelLogLayout);
		jPanelLogLayout.setHorizontalGroup(
				jPanelLogLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
				.addComponent(jScrollPaneLog, javax.swing.GroupLayout.DEFAULT_SIZE, 1150, Short.MAX_VALUE)
		);
		jPanelLogLayout.setVerticalGroup(
				jPanelLogLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
				.addComponent(jScrollPaneLog, javax.swing.GroupLayout.DEFAULT_SIZE, 83, Short.MAX_VALUE)
		);

		jTabbedPaneAll.addTab("Log", jPanelLog);

		jTableProperties.setModel(new javax.swing.table.DefaultTableModel(
				new Object [][] {
						{null, null, null, null},
						{null, null, null, null},
						{null, null, null, null},
						{null, null, null, null}
				},
				new String [] {
						"Title 1", "Title 2", "Title 3", "Title 4"
				}
		));
		jScrollPaneProperties.setViewportView(jTableProperties);

		javax.swing.GroupLayout jPanelPropertiesLayout = new javax.swing.GroupLayout(jPanelProperties);
		jPanelProperties.setLayout(jPanelPropertiesLayout);
		jPanelPropertiesLayout.setHorizontalGroup(
				jPanelPropertiesLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
				.addGroup(jPanelPropertiesLayout.createSequentialGroup()
						.addContainerGap()
						.addComponent(jScrollPaneProperties, javax.swing.GroupLayout.DEFAULT_SIZE, 1130, Short.MAX_VALUE)
						.addContainerGap())
		);
		jPanelPropertiesLayout.setVerticalGroup(
				jPanelPropertiesLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
				.addGroup(jPanelPropertiesLayout.createSequentialGroup()
						.addContainerGap()
						.addComponent(jScrollPaneProperties, javax.swing.GroupLayout.DEFAULT_SIZE, 61, Short.MAX_VALUE)
						.addContainerGap())
		);

		jTabbedPaneAll.addTab("Properties", jPanelProperties);

		jSplitPaneTopology.setRightComponent(jTabbedPaneAll);

		javax.swing.GroupLayout jPanelTopologyLayout = new javax.swing.GroupLayout(jPanelTopology);
		jPanelTopology.setLayout(jPanelTopologyLayout);
		jPanelTopologyLayout.setHorizontalGroup(
				jPanelTopologyLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
				.addComponent(jSplitPaneTopology, javax.swing.GroupLayout.DEFAULT_SIZE, 1157, Short.MAX_VALUE)
		);
		jPanelTopologyLayout.setVerticalGroup(
				jPanelTopologyLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
				.addComponent(jSplitPaneTopology, javax.swing.GroupLayout.DEFAULT_SIZE, 617, Short.MAX_VALUE)
		);

		jTabbedPane.addTab("Topology", jPanelTopology);

		jMenuFile.setText("File");

		jMenuItemAddWSDL.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_N, java.awt.event.InputEvent.CTRL_MASK));
		jMenuItemAddWSDL.setText("Add new WSDL");
		jMenuItemAddWSDL.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				jMenuItemAddWSDLActionPerformed(evt);
			}
		});
		jMenuFile.add(jMenuItemAddWSDL);

		jMenuItemExit.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_E, java.awt.event.InputEvent.CTRL_MASK));
		jMenuItemExit.setText("Exit");
		jMenuItemExit.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				jMenuItemExitActionPerformed(evt);
			}
		});
		jMenuFile.add(jMenuItemExit);

		jMenuBar.add(jMenuFile);

		jMenuEdit.setText("Edit");

		jMenuItemChangeColor.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_B, java.awt.event.InputEvent.CTRL_MASK));
		jMenuItemChangeColor.setText("Change background color");
		jMenuItemChangeColor.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				jMenuItemChangeColorActionPerformed(evt);
			}
		});
		jMenuEdit.add(jMenuItemChangeColor);

		jMenuItemRefresh.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_R, java.awt.event.InputEvent.CTRL_MASK));
		jMenuItemRefresh.setText("Refresh All");
		jMenuItemRefresh.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				jMenuItemRefreshActionPerformed(evt);
			}
		});
		jMenuEdit.add(jMenuItemRefresh);

		jMenuBar.add(jMenuEdit);

		setJMenuBar(jMenuBar);

		javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
		getContentPane().setLayout(layout);
		layout.setHorizontalGroup(
				layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
				.addComponent(jTabbedPane, javax.swing.GroupLayout.DEFAULT_SIZE, 1162, Short.MAX_VALUE)
		);
		layout.setVerticalGroup(
				layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
				.addComponent(jTabbedPane, javax.swing.GroupLayout.DEFAULT_SIZE, 645, Short.MAX_VALUE)
		);

		pack();
	}// </editor-fold>//GEN-END:initComponents

	public javax.swing.JTable getjTableProperties() {
		return jTableProperties;
	}

	private void jButtonPlayActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonPlayActionPerformed
		if(this.getMmr().getSelectedItem() != null) {
			ThreadMsgSender sender = new ThreadMsgSender((MockOperation) this.getMmr().getSelectedItem(), this.jLabelImage, this.jEditorPaneRequest, this.jEditorPaneResponse, this.jTextFieldSendTo.getText(), this);
			sender.start();
		}
	}//GEN-LAST:event_jButtonPlayActionPerformed

	private void jMenuItemRefreshActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemRefreshActionPerformed
		try {
			this.refreshAll();
		} catch (WSOUIClientException e) {
			e.printStackTrace();
			JOptionPane.showMessageDialog(this,
					e.getMessage(), 
					"Refresh Interrupted", JOptionPane.ERROR_MESSAGE);
		}
	}//GEN-LAST:event_jMenuItemRefreshActionPerformed

	private void jTabbedPaneMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jTabbedPaneMouseClicked
		if(this.jTabbedPane.getSelectedIndex() == 1) {
			// Refresh notif pane
			this.printAllNotifications();

		}
	}//GEN-LAST:event_jTabbedPaneMouseClicked

	private void jButtonFilterActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonFilterActionPerformed
		FilterFrame f = new FilterFrame(this, ((NotificationTableModel)this.jTableNotification.getModel()).getValue(this.jTableNotification.getSelectedRow()));
		f.setVisible(true);
	}//GEN-LAST:event_jButtonFilterActionPerformed

	private void jTreeMouseClicked(java.awt.event.MouseEvent evt) {
		if ((evt.getButton() == MouseEvent.BUTTON1)&& (evt.getClickCount() == 1)) {
			if(this.jTree.getSelectionPath() != null) {
				this.jTree.expandPath((TreePath) this.jTree.getSelectionPath());
				Object selectedItem = this.jTree.getSelectionPath().getLastPathComponent();
				if(selectedItem != null) {
					if(selectedItem instanceof MockService) {
						this.mmr.setService((MockService) selectedItem);
					} else if(selectedItem instanceof MockEndpoint) {
						this.mmr.setEndpoint((MockEndpoint) selectedItem);
					} else if(selectedItem instanceof MockBinding) {
						this.mmr.setBinding((MockBinding) selectedItem);
					} else if(selectedItem instanceof MockOperation) {
						MockOperation bop = (MockOperation) selectedItem;
						this.mmr.setOperation(bop);
						this.jEditorPaneRequest.setText(bop.getRequest());
					}
					this.mmr.jMenuItemSetAllActionPerformed(null);
				}
			}
		} else if ((evt.getButton() == MouseEvent.BUTTON3)&& (evt.getClickCount() == 1)) {
			if(this.jTree.getSelectionPath() != null) {
				Object selectedItem = this.jTree.getSelectionPath().getLastPathComponent();
				if(selectedItem != null) {
					if(selectedItem instanceof MockService) {
						this.mmr.setService((MockService) selectedItem);
					} else if(selectedItem instanceof Endpoint) {
						this.mmr.setEndpoint((MockEndpoint) selectedItem);
					} else if(selectedItem instanceof MockBinding) {
						this.mmr.setBinding((MockBinding) selectedItem);
					} else if(selectedItem instanceof MockOperation) {
						this.mmr.setOperation((MockOperation) selectedItem);
					}
					this.mmr.show(this.jTree, evt.getX(), evt.getY());
				}
			}
		}
	} 

	private void jMenuItemAddWSDLActionPerformed(java.awt.event.ActionEvent evt) {
		AddWsdlFrame newWsdl = new AddWsdlFrame(this);
		newWsdl.setVisible(true);
	}

	private void jMenuItemExitActionPerformed(java.awt.event.ActionEvent evt) {
		System.exit(0);
	}

	private void jListNotificationServerMouseClicked(java.awt.event.MouseEvent evt) {
		if(this.jListNotificationServer.getSelectedValue() != null) {
			currentNotificationServer = (NotificationConsumer_NotifierEndpoint_Server) this.jListNotificationServer.getSelectedValue();
			this.jTextFieldNotificationServer.setText(currentNotificationServer.getAddress());
			this.jTextFieldNumberOfNotificationReceived.setText(String.valueOf(((NotificationConsumerMock)currentNotificationServer.getImplementation()).getNotifications().size()));

			this.jTableNotification.setModel(new NotificationTableModel(((NotificationConsumerMock)currentNotificationServer.getImplementation()).getNotifications()));
		}
	}

	public void printAllNotifications() {
		int sum = 0;
		for(NotificationConsumer_NotifierEndpoint_Server server: this.notificationServers) {
			sum = sum + ((NotificationConsumerMock)server.getImplementation()).getNotifications().size();
		}
		this.jLabelTotalNumberValue.setText(String.valueOf(sum));
	}

	private void jButtonAddNotificationServerActionPerformed(java.awt.event.ActionEvent evt) {
		AddNotificationServerFrame server = new AddNotificationServerFrame(this);
		server.setVisible(true);
	}


	private void jTableNotificationMouseClicked(java.awt.event.MouseEvent evt) {
		if(this.jTableNotification.getSelectedRow() != -1) {
			NotifyGui notify = ((NotificationTableModel)this.jTableNotification.getModel()).getValue(this.jTableNotification.getSelectedRow());
			this.jEditorPaneNotification.setText(notify.toString());
		}
	}

	private void jMenuItemChangeColorActionPerformed(java.awt.event.ActionEvent evt) {
		ActionListener okActionListener = new ActionListener() {
			public void actionPerformed(ActionEvent actionEvent) {
				color = colorChooser.getColor();
				getFrame().setColor();
			}
		};

		final JDialog dialog = JColorChooser.createDialog(null,
				"Change background color", true, colorChooser,
				okActionListener, null);
		dialog.setVisible(true);
	}



	/**
	 * @param args the command line arguments
	 */
	public static void main(String args[]) {
		java.awt.EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
				    
					WSOUIClient c = new WSOUIClient();
					
					//c.getRegistry().createNode("node0", "http://easyesb.petalslink.com", "localhost", "9000", "8084", false);
					
					
					
					//		c.addNewWsdls(Thread.currentThread().getContextClassLoader().getResource("bpel2java/nrbc/prefect.wsdl"));
					c.setVisible(true);

				} catch (WSOUIClientException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
		});
	}

	// Variables declaration - do not modify//GEN-BEGIN:variables
	private javax.swing.JButton jButtonAddNotificationServer;
	private javax.swing.JButton jButtonFilter;
	private javax.swing.JButton jButtonPlay;
	private javax.swing.JEditorPane jEditorPaneNotification;
	private javax.swing.JEditorPane jEditorPaneRequest;
	private javax.swing.JEditorPane jEditorPaneResponse;
	private javax.swing.JLabel jLabelEndpointName;
	private javax.swing.JLabel jLabelImage;
	private javax.swing.JLabel jLabelImageLogo;
	private javax.swing.JLabel jLabelInterfaceQName;
	private javax.swing.JLabel jLabelNotificationNumberOfServer;
	private javax.swing.JLabel jLabelNotificationServerAddress;
	private javax.swing.JLabel jLabelNotificationServerSelected;
	private javax.swing.JLabel jLabelOperationName;
	private javax.swing.JLabel jLabelSendTo;
	private javax.swing.JLabel jLabelServiceQName;
	private javax.swing.JLabel jLabelTotalNumberName;
	private javax.swing.JLabel jLabelTotalNumberValue;
	private javax.swing.JList jListNotificationServer;
	private javax.swing.JMenuBar jMenuBar;
	private javax.swing.JMenu jMenuEdit;
	private javax.swing.JMenu jMenuFile;
	private javax.swing.JMenuItem jMenuItemAddWSDL;
	private javax.swing.JMenuItem jMenuItemChangeColor;
	private javax.swing.JMenuItem jMenuItemExit;
	private javax.swing.JMenuItem jMenuItemRefresh;
	private javax.swing.JPanel jPanelAllNotification;
	private javax.swing.JPanel jPanelLog;
	private javax.swing.JPanel jPanelNotificationEventClient;
	private javax.swing.JPanel jPanelProperties;
	private javax.swing.JPanel jPanelRequest;
	private javax.swing.JPanel jPanelResponse;
	private javax.swing.JPanel jPanelTopology;
	private javax.swing.JPanel jPanelView;
	private javax.swing.JPanel jPanelWebServiceClient;
	private javax.swing.JScrollPane jScrollPane;
	private javax.swing.JScrollPane jScrollPaneLog;
	private javax.swing.JScrollPane jScrollPaneNotificationEditor;
	private javax.swing.JScrollPane jScrollPaneNotificationTable;
	private javax.swing.JScrollPane jScrollPaneProperties;
	private javax.swing.JScrollPane jScrollPaneRequest;
	private javax.swing.JScrollPane jScrollPaneResponse;
	private javax.swing.JScrollPane jScrollPaneTree;
	private javax.swing.JSplitPane jSplitPaneTopology;
	private javax.swing.JTabbedPane jTabbedPane;
	private javax.swing.JTabbedPane jTabbedPaneAll;
	private javax.swing.JTable jTableNotification;
	private javax.swing.JTable jTableProperties;
	private javax.swing.JTextArea jTextAreaLog;
	private javax.swing.JTextField jTextFieldEndpointName;
	private javax.swing.JTextField jTextFieldInterfaceQName;
	private javax.swing.JTextField jTextFieldNotificationServer;
	private javax.swing.JTextField jTextFieldNumberOfNotificationReceived;
	private javax.swing.JTextField jTextFieldOperationName;
	private javax.swing.JTextField jTextFieldSendTo;
	private javax.swing.JTextField jTextFieldServiceQName;
	private javax.swing.JTree jTree;
	// End of variables declaration//GEN-END:variables

}
