/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.petalslink.easiestdemo.client.topology;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;

import javax.xml.namespace.QName;

import org.petalslink.easiestdemo.client.gui.Property;
import org.petalslink.easiestdemo.client.model.api.esb.ClientEndpointProxy;
import org.petalslink.easiestdemo.client.model.api.esb.Node;
import org.petalslink.easiestdemo.client.model.api.esb.ProviderEndpoint;
import org.petalslink.easiestdemo.client.model.api.esb.ProviderEndpointProxy;

/**
 *
 * @author Nico
 */
public class EsbG  {

	public static int DEFAULT_WIDTH = 150;
	public static int DEFAULT_HEIGHT = 100;

	private int lastx = 0;
	private int lasty = 0;
	private boolean move = false;

	private Rectangle rect;
	private TopologyView topology;

	private List<InternalClientProxyEndpointG> proxyClients = new ArrayList<InternalClientProxyEndpointG>();
	private List<InternalProviderEndpointG> providers = new ArrayList<InternalProviderEndpointG>();
	private List<InternalProviderProxyEndpointG> proxyProviders = new ArrayList<InternalProviderProxyEndpointG>();

	private List<Property> properties = new ArrayList<Property>();

	private Node model = null;

	public EsbG(TopologyView topology, Node node, int init_x, int init_y) {
		this.model = node;
		this.topology = topology;
		this.rect = new Rectangle(0, 0, DEFAULT_WIDTH, DEFAULT_HEIGHT);
		this.rect.setLocation(init_x, init_y);


		this.properties.add(new Property("name", this.model.getQName().getLocalPart()));
		this.properties.add(new Property("namespace", this.model.getQName().getNamespaceURI()));
		this.properties.add(new Property("administration service url", this.model.getAdministrationServiceDescription().getServices().iterator().next().getEndpoints()[0].getAddress()));
		this.properties.add(new Property("neighbour nodes", this.model.getNeighbourNodeNames()));
		this.properties.add(new Property("number of client proxy endpoints", this.model.getClientEndpointProxies().size()));
		this.properties.add(new Property("number of provider endpoints", this.model.getProviderEndpoints().size()));
		this.properties.add(new Property("number of provider proxy endpoints", this.model.getProviderEndpointProxies().size()));
	}

	public void update(Graphics g) {
		Graphics2D g2 = (Graphics2D) g;
		g2.setStroke(new BasicStroke(8.0f));

		this.proxyClients.clear();
		for(ClientEndpointProxy cep: model.getClientEndpointProxies()) {
			this.proxyClients.add(new InternalClientProxyEndpointG(this.topology, cep));
		}

		this.providers.clear();
		for(ProviderEndpoint pe: model.getProviderEndpoints()) {
			this.providers.add(new InternalProviderEndpointG(this.topology, pe));
		}

		this.proxyProviders.clear();
		for(ProviderEndpointProxy pep: model.getProviderEndpointProxies()) {
			this.proxyProviders.add(new InternalProviderProxyEndpointG(this.topology, pep));
		}

		if(lastx == 0 && lasty == 0) {
			Dimension textSize = getTextSize(g2);
			if(textSize.width > EsbG.DEFAULT_WIDTH) {
				this.rect.setSize(new Dimension(textSize.width + 10, EsbG.DEFAULT_HEIGHT));
			}
		}

		// Clears the rectangle that was previously drawn.
		//if (this.rect.x != lastx && this.rect.y != lasty) {
		if(move) {
			g2.setPaint(Color.white);
			g2.drawRect(lastx, lasty, (int) this.rect.getWidth(), (int) this.rect.getHeight());
			g2.fillRect(lastx, lasty, (int) this.rect.getWidth(), (int) this.rect.getHeight());
			lastx = this.rect.x;
			lasty = this.rect.y;
		}


		g2.setColor(new Color(132,112,255));
		g2.draw(this.rect);
		if(model.isMonitoringNode()) {
			g2.setColor(new Color(84,255,159));
		} else {
			g2.setColor(new Color(0,191,255));
		}
		g2.fill(this.rect);
		g2.setColor(Color.black);
		g2.drawString(this.model.getQName().getLocalPart(), this.rect.x+5, this.rect.y+15);


		int init_x = (int)(this.rect.x - InternalClientProxyEndpointG.DEFAULT_SIZE/2) ;
		int spacey = this.rect.height / (this.proxyClients.size()+1);
		int init_y = this.rect.y + spacey;
		for(InternalClientProxyEndpointG p: this.proxyClients) {
			p.setLocation(init_x, init_y);
			p.update(g2);
			init_y = init_y + spacey;
		}

		init_x = (int)(this.rect.x + (this.rect.getWidth()/2) - InternalProviderEndpointG.DEFAULT_SIZE/2) ;
		spacey = this.rect.height / (this.providers.size()+1);
		init_y = this.rect.y + spacey;
		for(InternalProviderEndpointG p: this.providers) {
			p.setLocation(init_x, init_y);
			p.update(g2);
			init_y = init_y + spacey;
		}

		init_x = (int)(this.rect.x + this.rect.getWidth() - InternalProviderProxyEndpointG.DEFAULT_SIZE/2) ;
		spacey = this.rect.height / (this.proxyProviders.size()+1);
		init_y = this.rect.y + spacey;
		for(InternalProviderProxyEndpointG proxyp: this.proxyProviders) {
			proxyp.setLocation(init_x, init_y);
			proxyp.update(g2);
			init_y = init_y + spacey;
		} 
	}

	private Dimension getTextSize(Graphics2D g2) {
		// get metrics from the graphics
		FontMetrics metrics = g2.getFontMetrics();
		// get the height of a line of text in this font and render context
		int hgt = metrics.getHeight();
		// get the advance of my text in this font and render context
		int adv = metrics.stringWidth(this.model.getQName().getLocalPart());
		// calculate the size of a box to hold the text with some padding.
		Dimension textSize = new Dimension(adv+2, hgt+2);

		return textSize;
	}

	public boolean contains(int x, int y) {
		return this.rect.contains(x, y);
	}

	public void setLocation(int x, int y) {
		Point pos = checkLocation(x, y);
		this.rect.x = pos.x;
		this.rect.y = pos.y;
	}

	private Point checkLocation(int x, int y) {
		Point p = new Point(x, y);
		if(x < this.topology.getX()) {
			p.x = this.topology.getX();
		} else if(x > this.topology.getX() + this.topology.getWidth() - this.rect.width) {
			p.x = this.topology.getX() + this.topology.getWidth() - this.rect.width;
		}
		if(y < this.topology.getY()) {
			p.y = this.topology.getY();
		} else if(y > this.topology.getY() + this.topology.getHeight() - this.rect.height) {
			p.y = this.topology.getY() + this.topology.getHeight() - this.rect.height;
		}

		return p;
	}

	public double getCenterX() {
		return this.rect.x + (this.rect.width/2);
	}

	public double getCenterY() {
		return this.rect.y + (this.rect.height/2);
	}

	public List<InternalProviderProxyEndpointG> getProxyProviders() {
		return proxyProviders;
	}

	public List<InternalClientProxyEndpointG> getProxyClients() {
		return proxyClients;
	}

	public List<InternalProviderEndpointG> getProviders() {
		return providers;
	}

	public QName getQName() {
		return this.model.getQName();
	}

	public List<QName> getNeighbourNodeNames() {
		return this.model.getNeighbourNodeNames();
	}

	public Node getModel() {
		return model;
	}

	public boolean isMove() {
		return move;
	}

	public void setMove(boolean move) {
		this.move = move;
	}

	public List<Property> getProperties() {
		return this.properties;
	}
}
