/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.easiestdemo.client.topology.menu.action;

import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.petalslink.easiestdemo.client.WSOUIClient;
import org.petalslink.easiestdemo.client.WSOUIClientException;
import org.petalslink.easiestdemo.client.model.api.Registry;
import org.petalslink.easiestdemo.client.topology.EsbG;
import org.petalslink.easiestdemo.client.topology.menu.action.BPELFilter;

public class StoreBpelFrame
extends JFrame {
    private WSOUIClient client;
    private Registry registry;
    private EsbG esb;
    private JButton jButtonBrowse;
    private JButton jButtonOk;
    private JLabel jLabelBpelUrl;
    private JPanel jPanelMain;
    private JTextField jTextFieldBpelUrl;

    public StoreBpelFrame(WSOUIClient client, EsbG esb) {
        this.initComponents();
        if (client != null) {
            this.jPanelMain.setBackground(client.getColor());
        }
        this.esb = esb;
        this.setTitle("Store Bpel on node: " + esb.getQName().getLocalPart());
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(WSOUIClient.ICON_IMAGE));
        this.client = client;
        this.registry = client.getRegistry();
        this.setLocation();
    }

    private void setLocation() {
        double heightScreen = Toolkit.getDefaultToolkit().getScreenSize().getHeight();
        double witdhScreen = Toolkit.getDefaultToolkit().getScreenSize().getWidth();
        this.setLocation((int)witdhScreen / 2 - this.getWidth() / 2, (int)heightScreen / 2 - this.getHeight() / 2);
    }

    private void initComponents() {
        this.jPanelMain = new JPanel();
        this.jLabelBpelUrl = new JLabel();
        this.jTextFieldBpelUrl = new JTextField();
        this.jButtonOk = new JButton();
        this.jButtonBrowse = new JButton();
        this.jLabelBpelUrl.setText("Bpel url:");
        this.jButtonOk.setText("OK");
        this.jButtonOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StoreBpelFrame.this.jButtonOkActionPerformed(evt);
            }
        });
        this.jButtonBrowse.setText("Browse...");
        this.jButtonBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StoreBpelFrame.this.jButtonBrowseActionPerformed(evt);
            }
        });
        GroupLayout jPanelMainLayout = new GroupLayout(this.jPanelMain);
        this.jPanelMain.setLayout(jPanelMainLayout);
        jPanelMainLayout.setHorizontalGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelMainLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabelBpelUrl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldBpelUrl, -2, 499, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonBrowse).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, jPanelMainLayout.createSequentialGroup().addContainerGap(594, Short.MAX_VALUE).addComponent(this.jButtonOk).addContainerGap()));
        jPanelMainLayout.setVerticalGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelMainLayout.createSequentialGroup().addContainerGap().addGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelBpelUrl).addComponent(this.jTextFieldBpelUrl, -2, -1, -2).addComponent(this.jButtonBrowse)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonOk).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelMain, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelMain, -2, -1, -2));
        this.pack();
    }

    private void jButtonOkActionPerformed(ActionEvent evt) {
        try {
            URL bpelURL = null;
            bpelURL = new File(this.jTextFieldBpelUrl.getText()).exists() ? new File(this.jTextFieldBpelUrl.getText()).toURI().toURL() : new URL(this.jTextFieldBpelUrl.getText());
            this.registry.storeBpel(this.esb.getModel(), bpelURL);
            this.client.getTopology().clear();
            this.client.getTopology().refresh();
            this.setVisible(false);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, e.getMessage(), "Store bpel Interrupted", 0);
        }
        catch (WSOUIClientException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, e.getMessage(), "Store bpel Interrupted", 0);
        }
    }

    private void jButtonBrowseActionPerformed(ActionEvent evt) {
        JFileChooser c = new JFileChooser();
        c.addChoosableFileFilter(new BPELFilter());
        c.setAcceptAllFileFilterUsed(false);
        int rVal = c.showOpenDialog(this);
        if (rVal == 0) {
            this.jTextFieldBpelUrl.setText(c.getSelectedFile().getAbsolutePath());
        }
        if (rVal == 1) {
            this.jTextFieldBpelUrl.setText("");
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new StoreBpelFrame(null, null).setVisible(true);
            }
        });
    }
}

