package org.petalslink.easiestdemo.client.topology;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;

import org.petalslink.easiestdemo.client.gui.Property;

public class RectangleG implements Shape {

	public static int DEFAULT_WIDTH = 150;
	public static int DEFAULT_HEIGHT = 100;
	
	private int lastx = 0;
	private int lasty = 0;
	private boolean move = false;
	
	protected String name;
	protected Rectangle rect;
	protected TopologyView topology;
	protected Color backgroundColor = new Color(0,191,255);
	protected Color borderColor = new Color(132,112,255);
	
	protected List<Property> properties = new ArrayList<Property>();


	public RectangleG(TopologyView view, String name, int init_x, int init_y) {
		this.topology = view;		
		this.rect = new Rectangle(0, 0, DEFAULT_WIDTH, DEFAULT_HEIGHT);
		this.rect.setLocation(init_x, init_y);
		this.name = name;
	}
	
	int getWidth() {
		return this.topology.getClient().getCustomView().getRectangleWidth();
	}
	
	int getHeight() {
		return this.topology.getClient().getCustomView().getRectangleHeight();
	}
	
	public boolean isMove() {
		return move;
	}

	public void setMove(boolean move) {
		this.move = move;
	}

	public List<Property> getProperties() {
		return this.properties;
	}
	
	public boolean contains(int x, int y) {
		return this.rect.contains(x, y);
	}

	public void setLocation(int x, int y) {
		Point pos = checkLocation(x, y);
		this.rect.x = pos.x;
		this.rect.y = pos.y;
	}

	private Point checkLocation(int x, int y) {
		Point p = new Point(x, y);
		if(x < this.topology.getX()) {
			p.x = this.topology.getX();
		} else if(x > this.topology.getX() + this.topology.getWidth() - this.rect.width) {
			p.x = this.topology.getX() + this.topology.getWidth() - this.rect.width;
		}
		if(y < this.topology.getY()) {
			p.y = this.topology.getY();
		} else if(y > this.topology.getY() + this.topology.getHeight() - this.rect.height) {
			p.y = this.topology.getY() + this.topology.getHeight() - this.rect.height;
		}

		return p;
	}

	public double getCenterX() {
		return this.rect.x + (this.rect.width/2);
	}

	public double getCenterY() {
		return this.rect.y + (this.rect.height/2);
	}
	
	public void draw(Graphics g) {
		Graphics2D g2 = (Graphics2D) g;
		
		this.rect.width = this.getWidth();
		this.rect.height = this.getHeight();
		
		if(lastx == 0 && lasty == 0) {
			Dimension textSize = getTextSize(g2);
			if(textSize.width > EsbG.DEFAULT_WIDTH) {
				this.rect.setSize(new Dimension(textSize.width + 10, EsbG.DEFAULT_HEIGHT));
			}
		}

		// Clears the rectangle that was previously drawn.
		//if (this.rect.x != lastx && this.rect.y != lasty) {
		if(move) {
			g2.setPaint(Color.white);
			g2.drawRect(lastx, lasty, (int) this.rect.getWidth(), (int) this.rect.getHeight());
			g2.fillRect(lastx, lasty, (int) this.rect.getWidth(), (int) this.rect.getHeight());
			lastx = this.rect.x;
			lasty = this.rect.y;
		}


		g2.setColor(this.borderColor);
		g2.draw(this.rect);
		g2.setColor(this.backgroundColor);
		g2.fill(this.rect);
		g2.setColor(Color.black);
		g2.drawString(this.name, this.rect.x+5, this.rect.y+15);

	}
	
	public Color getBackgroundColor() {
		return backgroundColor;
	}

	public void setBackgroundColor(Color backgroundColor) {
		this.backgroundColor = backgroundColor;
	}

	public Color getBorderColor() {
		return borderColor;
	}

	public void setBorderColor(Color borderColor) {
		this.borderColor = borderColor;
	}

	private Dimension getTextSize(Graphics2D g2) {
		// get metrics from the graphics
		FontMetrics metrics = g2.getFontMetrics();
		// get the height of a line of text in this font and render context
		int hgt = metrics.getHeight();
		// get the advance of my text in this font and render context
		int adv = metrics.stringWidth(this.name);
		// calculate the size of a box to hold the text with some padding.
		Dimension textSize = new Dimension(adv+2, hgt+2);

		return textSize;
	}
}
