package org.petalslink.easiestdemo.client.notification;

import java.util.GregorianCalendar;

import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;

import org.petalslink.easiestdemo.client.WSOUIClientException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.wsstar.jaxb.notification.base.NotificationMessageHolderType;
import com.ebmwebsourcing.wsstar.jaxb.notification.base.Notify;

public class NotifyGui {

	public String emissionDate = null;

	public String receptionDate = null;

	public String from = null;

	public Notify notify = null;

	public String notifyString = null;

	static {
		try {
			SOAJAXBContext.getInstance().addOtherObjectFactory(com.ebmwebsourcing.wsstar.jaxb.notification.base.ObjectFactory.class);
		} catch (SOAException e) {
			// do nothing
			e.printStackTrace();
		}
	}

	public NotifyGui(Notify notify) throws WSOUIClientException {
		this.notify = notify;
		if(this.notify.getAny() != null) {
			for(Object obj: this.notify.getAny()) {
				if(obj instanceof Element) {
					Element elmt = (Element)obj;
					if(elmt.getLocalName().equals("emissionDate") && elmt.getNamespaceURI().equals("http://wwww.petalslink.com/wsoui/wsnotification")) {
						this.emissionDate = elmt.getNodeValue();
					}
				}
			}
		}
		if(this.notify.getNotificationMessage() != null && this.notify.getNotificationMessage().size() == 1) {
			NotificationMessageHolderType nmh = this.notify.getNotificationMessage().get(0);
			if(nmh.getProducerReference() != null && nmh.getProducerReference().getAddress() != null){
				this.from = nmh.getProducerReference().getAddress().getValue();
			}else{
				this.from = "null";
			}
		} else {
			throw new WSOUIClientException("Client Restriction: Notification has no or several messages!!!");
		}
		try {
			this.receptionDate = DatatypeFactory.newInstance().newXMLGregorianCalendar((GregorianCalendar) GregorianCalendar.getInstance()).toString();
		} catch (DatatypeConfigurationException e) {
			throw new WSOUIClientException(e);
		}
		Document doc = null;
		try {
			doc = SOAJAXBContext.getInstance().unmarshallAnyElement(notify);
		} catch (SOAException e) {
			this.notifyString = e.getMessage();
			e.printStackTrace();
		}
		this.notifyString = XMLPrettyPrinter.prettyPrint(doc);
	}

	public String getEmissionDate() {
		return emissionDate;
	}

	public void setEmissionDate(String emissionDate) {
		this.emissionDate = emissionDate;
	}

	public String getReceptionDate() {
		return receptionDate;
	}

	public void setReceptionDate(String receptionDate) {
		this.receptionDate = receptionDate;
	}

	public String getFrom() {
		return from;
	}

	public void setFrom(String from) {
		this.from = from;
	}

	public Notify getNotify() {
		return notify;
	}

	public String toString() {
		String res = null;
		if(this.notifyString != null) {
			res = this.notifyString;
		} else {
			Document doc = null;
			try {
				doc = SOAJAXBContext.getInstance().unmarshallAnyElement(notify);
			} catch (SOAException e) {
				this.notifyString = e.getMessage();
				e.printStackTrace();
			}
			this.notifyString = XMLPrettyPrinter.prettyPrint(doc);
		}
		return res;
	}
}
