/**
 * PETALS - PETALS Services Platform.
 * Copyright (c) 2006 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $Id$
 * -------------------------------------------------------------------------
 */

package org.petalslink.easiestdemo.client.gui;

import java.awt.Component;
import java.net.URL;

import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

import org.petalslink.easiestdemo.client.model.api.esb.Node;
import org.petalslink.easiestdemo.client.model.api.ws.MockBinding;
import org.petalslink.easiestdemo.client.model.api.ws.MockEndpoint;
import org.petalslink.easiestdemo.client.model.api.ws.MockOperation;
import org.petalslink.easiestdemo.client.model.api.ws.MockService;



/**
 *
 *
 * @author Nicolas SALATGE - eBM WebSourcing
 */
public class TreeRegistryCellRenderer extends DefaultTreeCellRenderer {

	private static final ImageIcon nodeIcon = createImageIcon(Thread.currentThread().getContextClassLoader().getResource("images/node.png"));
	private static final ImageIcon serviceIcon = createImageIcon(Thread.currentThread().getContextClassLoader().getResource("images/service.png"));
	private static final ImageIcon endpointIcon = createImageIcon(Thread.currentThread().getContextClassLoader().getResource("images/endpoint.png"));
	private static final ImageIcon interfaceIcon = createImageIcon(Thread.currentThread().getContextClassLoader().getResource("images/interface.png"));

	/**
	 * serialVersionUID
	 */
	private static final long serialVersionUID = 1L;

	/** Creates a new instance of DevisDirectoryTreeCellRenderer */
	public TreeRegistryCellRenderer() {
	}

	@Override
	public Component getTreeCellRendererComponent(final JTree tree,
			final Object value, final boolean selected, final boolean expanded,
			final boolean leaf, final int row, final boolean hasFocus) {
		super.getTreeCellRendererComponent(tree, value, selected, expanded,
				leaf, row, hasFocus);

		if(value instanceof Node){
			Node val = (Node)value;
			this.setText(val.getQName().getLocalPart() + " (" + val.getQName().getNamespaceURI() + ")");
			this.setIcon(nodeIcon);
			this.setToolTipText("This is a node.");
		} else if(value instanceof MockService){
			MockService val = (MockService)value;
			this.setText(val.getQName().getLocalPart() + " (" + val.getQName().getNamespaceURI() + ")");
			this.setIcon(serviceIcon);
			this.setToolTipText("This is a service.");
		} else if(value instanceof MockEndpoint){
			this.setText(((MockEndpoint) value).getName());
			this.setIcon(endpointIcon);
			this.setToolTipText("This is a endpoint.");
		} else if(value instanceof MockBinding) {
			this.setText(((MockBinding)value).getQName().getLocalPart() + " (" + ((MockBinding)value).getQName().getNamespaceURI() + ")");
			this.setIcon(interfaceIcon);
			this.setToolTipText("This is a binding.");
		} else if(value instanceof MockOperation) {
			this.setText(((MockOperation)value).getName().toString());
		} else {
			this.setText(value.toString());
		}
		return this;
	}


	/** Returns an ImageIcon, or null if the path was invalid. */
	private static ImageIcon createImageIcon(URL imgURL) {
		ImageIcon img = new ImageIcon(imgURL);
		return img;
	}

}
